CREATE TABLE em_cp_calendar(
    id varchar(32)  NOT NULL,
    organizer varchar(32) NOT NULL,
    readonly int DEFAULT 1,
    cal_id varchar(50) NOT NULL,
    summary varchar(128) NOT NULL,
    color varchar(32) NOT NULL,
    description varchar(512) NOT NULL,
    shares TEXT NOT NULL,
    corp_id varchar(64) NOT NULL,
    status INT DEFAULT 1,
    create_user_id varchar(32) DEFAULT NULL,
    create_time TIMESTAMP  WITHOUT TIME ZONE DEFAULT NULL,
    update_user_id varchar(32) DEFAULT NULL,
    update_time TIMESTAMP  WITHOUT TIME ZONE DEFAULT NULL,
    tenant_id varchar(32) DEFAULT NULL,
    PRIMARY KEY (ID)
)
;
COMMENT ON TABLE em_cp_calendar IS '企业微信日历表'
;
COMMENT ON COLUMN em_cp_calendar.id  IS '主键ID'
;
COMMENT ON COLUMN em_cp_calendar.organizer  IS '日历组织者'
;
COMMENT ON COLUMN em_cp_calendar.readonly  IS '组织者不可在日历上添加日程 0-否 1-是'
;
COMMENT ON COLUMN em_cp_calendar.cal_id  IS '企业微信接口返回的日程id'
;
COMMENT ON COLUMN em_cp_calendar.summary  IS '日历标题'
;
COMMENT ON COLUMN em_cp_calendar.color  IS '日历颜色'
;
COMMENT ON COLUMN em_cp_calendar.description  IS '描述'
;
COMMENT ON COLUMN em_cp_calendar.shares  IS '日历共享成员列表(<=2000)'
;
COMMENT ON COLUMN em_cp_calendar.corp_id  IS '本地企业号id'
;
COMMENT ON COLUMN em_cp_calendar.status  IS '状态：1-正常、3-删除'
;
COMMENT ON COLUMN em_cp_calendar.create_user_id  IS '创建人'
;
COMMENT ON COLUMN em_cp_calendar.create_time  IS '创建时间'
;
COMMENT ON COLUMN em_cp_calendar.update_user_id  IS '修改人'
;
COMMENT ON COLUMN em_cp_calendar.update_time  IS '修改时间'
;
COMMENT ON COLUMN em_cp_calendar.tenant_id  IS '企业租户ID'
;
