CREATE TABLE em_agent_extendmenu (
  id VARCHAR (32) NOT NULL,
  extend_key VARCHAR (32) NOT NULL,
  extend_pkey VARCHAR (32) DEFAULT NULL ,
  extend_icon VARCHAR (32) DEFAULT NULL ,
  extend_name VARCHAR (32) DEFAULT NULL ,
  associate_agent_id VARCHAR (32) NOT NULL ,
  extend_func_type INT DEFAULT 2 ,
  extend_func_setting VARCHAR (200) NOT NULL,
  showorder INT DEFAULT NULL ,
  status INT DEFAULT 1,
  create_user_id varchar(32) DEFAULT NULL,
  create_time TIMESTAMP  WITHOUT TIME ZONE DEFAULT NULL,
  update_user_id varchar(32) DEFAULT NULL,
  update_time TIMESTAMP  WITHOUT TIME ZONE DEFAULT NULL,
  tenant_id varchar(32) DEFAULT NULL,
  PRIMARY KEY (ID)
)
;


CREATE INDEX extendmsg_associate_agentid ON em_agent_extendmenu(associate_agent_id)
;

COMMENT ON TABLE em_agent_extendmenu is '消息分享按钮菜单信息表'
;
COMMENT ON COLUMN em_agent_extendmenu.id IS '主键'
;
COMMENT ON COLUMN em_agent_extendmenu.extend_key IS '该分享按钮记录的标识key'
;
COMMENT ON COLUMN em_agent_extendmenu.extend_pkey IS '该分享按钮所属的父按钮记录key，为空表示一级按钮'
;
COMMENT ON COLUMN em_agent_extendmenu.extend_icon IS '该分享按钮图标，默认为空,使用应用或者门户本身logo，如果设置将强制指定'
;
COMMENT ON COLUMN em_agent_extendmenu.extend_name IS '该分享按钮标题，默认为空,使用应用或者门户本身标题，如果设置将强制指定'
;
COMMENT ON COLUMN em_agent_extendmenu.associate_agent_id IS '分享按钮归属的应用id'
;
COMMENT ON COLUMN em_agent_extendmenu.extend_func_type IS '分享按钮对应的功能类型，1-打开门户，2-打开应用，3-自定义链接'
;
COMMENT ON COLUMN em_agent_extendmenu.extend_func_setting IS '分享按钮对应的功能数据，当msg_func为1时表示应用id，为3时表示自定义链接地址'
;