CREATE TABLE EM_SYS_MSG_CREATE_DING_RIGHT (
	ID VARCHAR(32) NOT NULL,
	HRM_DATA_ID VARCHAR(32) DEFAULT NULL,
	HRM_DATA_TYPE SMALLINT DEFAULT NULL,
	STATUS SMALLINT DEFAULT '1',
	CREATE_USER_ID VARCHAR(32) DEFAULT NULL,
	CREATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	UPDATE_USER_ID VARCHAR(32) DEFAULT NULL,
	UPDATE_TIME TIMESTAMP WITHOUT TIME ZONE DEFAULT NULL,
	TENANT_ID VARCHAR(32) DEFAULT NULL,
	PRIMARY KEY (ID)
)
;

COMMENT ON TABLE EM_SYS_MSG_CREATE_DING_RIGHT IS '消息创建必达使用权限设置表'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_DING_RIGHT.ID IS '主键ID'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_DING_RIGHT.HRM_DATA_ID IS '通讯录成员或部门表ID'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_DING_RIGHT.HRM_DATA_TYPE IS '通讯录数据类型：1-成员，2-部门（含下级），3-标签，4-部门（不含下级）'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_DING_RIGHT.STATUS IS '状态：1-正常，3-删除'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_DING_RIGHT.CREATE_USER_ID IS '创建人'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_DING_RIGHT.CREATE_TIME IS '创建时间'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_DING_RIGHT.UPDATE_USER_ID IS '修改人'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_DING_RIGHT.UPDATE_TIME IS '修改时间'
;

COMMENT ON COLUMN EM_SYS_MSG_CREATE_DING_RIGHT.TENANT_ID IS '企业租户ID'
;

CREATE INDEX IDX_EM_SYS_MSG_CREATE_DING_RIGHT_HRM_DATA_ID591 ON EM_SYS_MSG_CREATE_DING_RIGHT(HRM_DATA_ID)
;
CREATE INDEX IDX_EM_SYS_MSG_CREATE_DING_RIGHT_TENANT_ID508 ON EM_SYS_MSG_CREATE_DING_RIGHT(TENANT_ID)
;