create index em_shmr_group  on Social_historyMsgRight(userId,msgId);
/
CREATE TABLE OFROUTEMESSAGE (
	MESSAGEID SERIAL NOT NULL,
	JID VARCHAR(128) NOT NULL,
	CREATIONDATE DECIMAL(38, 0) NOT NULL,
	MESSAGE TEXT NOT NULL,
	FROMJID VARCHAR(128) DEFAULT NULL,
	PRIMARY KEY (MESSAGEID)
);
/
CREATE INDEX index_ormjid ON OFROUTEMESSAGE (jid);
/
CREATE INDEX index_ormcreationDate ON OFROUTEMESSAGE (creationDate);
/
CREATE TABLE OFHASROUTEDMESSAGE (
	MESSAGEID VARCHAR(128) NOT NULL,
	JID VARCHAR(128) NOT NULL,
	MESSAGE TEXT NOT NULL,
	CREATIONDATE DECIMAL(38, 0) DEFAULT NULL
);
/
CREATE INDEX index_ohrmmessageID ON OFHASROUTEDMESSAGE (messageID);
/
CREATE INDEX index_ohrmjid ON OFHASROUTEDMESSAGE (jid);
/
CREATE INDEX index_OFHASRMcreationDate ON OFHASROUTEDMESSAGE(creationDate);
/
CREATE TABLE OFPUSHDEVICE (
	PUSHID SERIAL NOT NULL,
	USERID VARCHAR(180) NOT NULL,
	DEVICETYPE VARCHAR(300) NOT NULL,
	TOKEN VARCHAR(1000) NOT NULL,
	PUSHSTATUS VARCHAR(600) DEFAULT NULL,
	LANGUAGE VARCHAR(60) DEFAULT NULL,
	PUSHKITDEVICETOKEN VARCHAR(700) DEFAULT NULL,
	MOBILEVERSION VARCHAR(12) DEFAULT NULL,
	PACKAGENAME VARCHAR(600) DEFAULT NULL,
	PRIMARY KEY (PUSHID)
);
/
CREATE TABLE OFPUSHSETTING (
	TARGETID VARCHAR(600) NOT NULL,
	TARGETTYPE VARCHAR(600) NOT NULL,
	USERNAME VARCHAR(600) NOT NULL,
	PROPVALUE VARCHAR(200) NOT NULL
);
/
CREATE TABLE HISTORYMSGRECENTLY (
	ID SERIAL NOT NULL,
	FROMUSERID VARCHAR(600) DEFAULT NULL,
	TARGETID VARCHAR(600) DEFAULT NULL,
	TARGETTYPE VARCHAR(600) DEFAULT NULL,
	GROUPID VARCHAR(600) DEFAULT NULL,
	CLASSNAME VARCHAR(600) DEFAULT NULL,
	MSGCONTENT TEXT,
	EXTRA TEXT,
	TYPE VARCHAR(600) DEFAULT NULL,
	IMAGEURI VARCHAR(600) DEFAULT NULL,
	DATETIME VARCHAR(600) DEFAULT NULL,
	MSGID VARCHAR(600) DEFAULT NULL,
	FULLAMOUNT TEXT,
	PRIMARY KEY (ID)
);
/
CREATE INDEX index_hmrUserId ON HistoryMsgRecently (fromUserId);
/
CREATE INDEX index_hmrtargetId ON HistoryMsgRecently (targetId);
/
CREATE INDEX index_hmrGroupId ON HistoryMsgRecently (GroupId);
/
CREATE INDEX index_hmrdateTime ON HistoryMsgRecently (dateTime);
/
CREATE INDEX index_hmrmsgid ON HistoryMsgRecently (msgid);
/
insert into ofProperty(name,propValue) values ('xmpp.client.processing.threads','1000');
/
insert into ofProperty(name,propValue) values ('httpbind.client.processing.threads','1000');
/
insert into ofProperty(name,propValue) values ('xmpp.client.roster.active','false');
/
insert into ofProperty(name,propValue) values ('xmpp.pep.enabled','false');
/
CREATE TABLE OFFUNSETTING (
	USERID VARCHAR(600) NOT NULL,
	FUNNAME VARCHAR(300) NOT NULL,
	FUNVALUE VARCHAR(1200) NOT NULL
);

/
CREATE INDEX index_funsetUserId ON OFFUNSETTING (userid);
/
CREATE INDEX index_funsetUsername ON OFFUNSETTING (funname);
/
CREATE TABLE OFTEMPORARYRELATIONSHIP (
	USERNAME VARCHAR(300) NOT NULL,
	FOLLOWUSERNAME VARCHAR(300) NOT NULL,
	PRIMARY KEY (USERNAME, FOLLOWUSERNAME)
);
/
CREATE INDEX index_im_RecentConver_Targetid ON social_IMRecentConver (targetid);
/
CREATE INDEX index_im_RecentConver_Userid ON social_IMRecentConver (userid);
/
CREATE TABLE OFPUSHINFO (
	ID SERIAL NOT NULL,
	DEVICETYPE VARCHAR(300) NOT NULL,
	PACKAGENAME VARCHAR(600) NOT NULL,
	APPKEY VARCHAR(700) DEFAULT NULL,
	SECRET VARCHAR(700) DEFAULT NULL,
	APPNAME VARCHAR(700) DEFAULT NULL,
    appId varchar(300) DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
CREATE TABLE OFUNITEMSGINFO (
	ID SERIAL NOT NULL,
	UNITEMSGID VARCHAR(700) DEFAULT NULL,
	MSGIDS TEXT,
	PRIMARY KEY (ID)
);
/
CREATE TABLE OFMSGCOLLECT (
	ID SERIAL NOT NULL,
	USERNAME VARCHAR(700) DEFAULT NULL,
	MSGID VARCHAR(700) DEFAULT NULL,
	MSGCONTENT TEXT,
	CLASSNAME VARCHAR(600) DEFAULT NULL,
	CREATETIME VARCHAR(600) DEFAULT NULL,
	COLLECTSOURCE VARCHAR(3000) DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
CREATE INDEX index_ofMsgCollectusername ON ofMsgCollect(username);
/
CREATE INDEX index_ofMsgCollectclassName ON ofMsgCollect(className);
/
CREATE INDEX index_ofMsgCollectmsgId ON ofMsgCollect(msgId);
/
create index index_mobile_dingreciver_dingid on mobile_dingReciver(dingid);
/
create index index_mobile_dingreciver_userid on mobile_dingReciver(userid);
/
create index index_mobile_ding_id on mobile_ding(id);
/
CREATE TABLE OFDELETEHISTORYMSG (
	ID SERIAL NOT NULL,
	OPERATOR VARCHAR(700) DEFAULT NULL,
	OPERATORTIME VARCHAR(200) DEFAULT NULL,
	MSGID VARCHAR(700) DEFAULT NULL,
	MSGCONTENT TEXT,
	FROMUSERID VARCHAR(300) DEFAULT NULL,
	TARGETTYPE VARCHAR(120) DEFAULT NULL,
	OPERATORIP VARCHAR(300) DEFAULT NULL,
	OPEARTORDEVICE VARCHAR(200) DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
CREATE TABLE OFMSGSTATISTICDAY (
	ID SERIAL NOT NULL,
	USERID VARCHAR(700) NOT NULL,
	DAY VARCHAR(200) DEFAULT NULL,
	MONTH VARCHAR(200) DEFAULT NULL,
	YEAR VARCHAR(200) DEFAULT NULL,
	SENDCOUNT INT DEFAULT NULL,
	RECEIVECOUNT INT DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
create index msgstaday_userId on OFMSGSTATISTICDAY(userId);
/
create index msgstaday_day on OFMSGSTATISTICDAY(day);
/
create index msgstaday_month on OFMSGSTATISTICDAY(month);
/
create index msgstaday_year on OFMSGSTATISTICDAY(year);
/
CREATE TABLE OFMSGSTATISTICMONTH (
	ID SERIAL NOT NULL,
	USERID VARCHAR(700) NOT NULL,
	MONTH VARCHAR(200) DEFAULT NULL,
	YEAR VARCHAR(200) DEFAULT NULL,
	SENDCOUNT INT DEFAULT NULL,
	RECEIVECOUNT INT DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
create index msgstamonth_userId on OFMSGSTATISTICMONTH(userId);
/
create index msgstamonth_month on OFMSGSTATISTICMONTH(month);
/
create index msgstamonth_year on OFMSGSTATISTICMONTH(year);
/
CREATE TABLE OFMSGSTATISTICYEAR (
	ID SERIAL NOT NULL,
	USERID VARCHAR(700) NOT NULL,
	YEAR VARCHAR(200) DEFAULT NULL,
	SENDCOUNT INT DEFAULT NULL,
	RECEIVECOUNT INT DEFAULT NULL,
	PRIMARY KEY (ID)
);

/
create index msgstayear_userId on OFMSGSTATISTICYEAR(userId);
/
create index msgstayear_year on OFMSGSTATISTICYEAR(year);
/
CREATE TABLE OFMSGSTATISTICCHATDAY (
	ID SERIAL NOT NULL,
	USERID VARCHAR(200) NOT NULL,
	TARGETID VARCHAR(1200) DEFAULT NULL,
	TARGETTYPE VARCHAR(24) DEFAULT NULL,
	DAY VARCHAR(200) DEFAULT NULL,
	MONTH VARCHAR(200) DEFAULT NULL,
	YEAR VARCHAR(200) DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
create index msgstachatday_userId on OFMSGSTATISTICCHATDAY(userId);
/
create index msgstachatday_day on OFMSGSTATISTICCHATDAY(day);
/
create index msgstachatday_month on OFMSGSTATISTICCHATDAY(month);
/
create index msgstachatday_year on OFMSGSTATISTICCHATDAY(year);
/
CREATE TABLE OFMSGSTATISTICCHATMONTH (
	ID SERIAL NOT NULL,
	USERID VARCHAR(700) NOT NULL,
	MONTH VARCHAR(200) DEFAULT NULL,
	YEAR VARCHAR(200) DEFAULT NULL,
	CHATCOUNT INT DEFAULT NULL,
	GROUPCHATCOUNT INT DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
create index msgstamonthchat_userId on OFMSGSTATISTICCHATMONTH(userId);
/
create index msgstamonthchat_month on OFMSGSTATISTICCHATMONTH(month);
/
create index msgstamonthchat_year on OFMSGSTATISTICCHATMONTH(year);
/
CREATE TABLE OFMSGSTATISTICCHATYEAR (
	ID SERIAL NOT NULL,
	USERID VARCHAR(200) NOT NULL,
	YEAR VARCHAR(200) DEFAULT NULL,
	CHATCOUNT INT DEFAULT NULL,
	GROUPCHATCOUNT INT DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
create index msgstachatyear_userId on OFMSGSTATISTICCHATYEAR(userId);
/
create index msgstachatyear_year on OFMSGSTATISTICCHATYEAR(year);
/
CREATE TABLE OFMSGPUSHSETTING (
	ID SERIAL NOT NULL,
	USERID VARCHAR(200) NOT NULL,
	PUSHSTATUS VARCHAR(24) DEFAULT NULL,
	STARTTIME VARCHAR(200) DEFAULT NULL,
	ENDTIME VARCHAR(200) DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
create index ofmsgpushsetting_userId on ofmsgpushsetting(userId);
/
CREATE TABLE OFCONVERSTATISDAY (
	ID SERIAL NOT NULL,
	USERID VARCHAR(200) NOT NULL,
	TARGETID VARCHAR(1200) DEFAULT NULL,
	TARGETTYPE VARCHAR(24) DEFAULT NULL,
	DAY VARCHAR(200) DEFAULT NULL,
	MONTH VARCHAR(200) DEFAULT NULL,
	YEAR VARCHAR(200) DEFAULT NULL,
	SENDCOUNT INT DEFAULT NULL,
	RECEIVECOUNT INT DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
create index converstatis_userId on OFCONVERSTATISDAY(userId);
/
create index converstatis_targetType on OFCONVERSTATISDAY(targetType);
/
create index converstatis_day on OFCONVERSTATISDAY(day);
/
create index converstatis_month on OFCONVERSTATISDAY(month);
/
create index converstatis_year on OFCONVERSTATISDAY(year);
/
CREATE TABLE OFCONVERSTATISMONTH (
	ID SERIAL NOT NULL,
	USERID VARCHAR(700) NOT NULL,
	TARGETID VARCHAR(1200) DEFAULT NULL,
	TARGETTYPE VARCHAR(24) DEFAULT NULL,
	MONTH VARCHAR(200) DEFAULT NULL,
	YEAR VARCHAR(200) DEFAULT NULL,
	SENDCOUNT INT DEFAULT NULL,
	RECEIVECOUNT INT DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
create index converstatism_userId on OFCONVERSTATISMONTH(userId);
/
create index converstatism_targetType on OFCONVERSTATISMONTH(targetType);
/
create index converstatism_month on OFCONVERSTATISMONTH(month);
/
create index converstatism_year on OFCONVERSTATISMONTH(year);
/
CREATE TABLE OFCONVERSTATISYEAR (
	ID SERIAL NOT NULL,
	USERID VARCHAR(700) NOT NULL,
	TARGETID VARCHAR(1200) DEFAULT NULL,
	TARGETTYPE VARCHAR(24) DEFAULT NULL,
	YEAR VARCHAR(200) DEFAULT NULL,
	SENDCOUNT INT DEFAULT NULL,
	RECEIVECOUNT INT DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
create index converstatisy_userId on OFCONVERSTATISYEAR(userId);
/
create index conversatisy_targetType on OFCONVERSTATISYEAR(targetType);
/
create index converstatisy_year on OFCONVERSTATISYEAR(year);
/
CREATE TABLE SOCIAL_HISTORYMSGRECENTLYRIGHT (
	ID SERIAL NOT NULL,
	USERID VARCHAR(600) DEFAULT NULL,
	MSGID VARCHAR(600) DEFAULT NULL,
	ISDEL INT DEFAULT NULL,
	DATETIME VARCHAR(600) DEFAULT NULL,
	GROUPID VARCHAR(600) DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
CREATE INDEX hmrr_userid_index ON Social_historyMsgRecentlyRight(userId);
/
CREATE INDEX hmrr_msgid_index ON Social_historyMsgRecentlyRight(msgId); 
/
CREATE INDEX hmrr_datetime_idx ON Social_historyMsgRecentlyRight(datetime);
/
CREATE INDEX hmrr_groupId_idx ON Social_historyMsgRecentlyRight(groupId);
/
CREATE INDEX em_shhmr_group  ON Social_historyMsgRecentlyRight(userId,msgId);
/
CREATE TABLE ofshareMessageNew (
	ID SERIAL NOT NULL,
	USERID VARCHAR(700) DEFAULT NULL,
	SHAREUSERID VARCHAR(700) DEFAULT NULL,
	MSGID VARCHAR(700) DEFAULT NULL,
	GROUPID VARCHAR(700) DEFAULT NULL,
	SHARETYPE VARCHAR(700) DEFAULT NULL,
	SHAREID VARCHAR(700) DEFAULT NULL,
	SHARETIME VARCHAR(120) DEFAULT NULL,
	TARGETID VARCHAR(700) DEFAULT NULL,
	TARGETTYPE VARCHAR(12) DEFAULT NULL,
	shareTimes VARCHAR(60),
	PRIMARY KEY (ID)
);
/
create index osm_shareType on ofshareMessageNew(targetId);
/
create index osm_shareId on ofshareMessageNew(shareId);
/
CREATE TABLE HISTORYMSGRECENTLYTEMP (
	GROUPID VARCHAR(700) DEFAULT NULL,
	MAXDATETIME VARCHAR(700) DEFAULT NULL,
	MINDATETIME VARCHAR(700) DEFAULT NULL
);
/
create index hmrt_groupId on historyMsgRecentlytemp(groupId);
/
create index hmrt_maxDatetime on historyMsgRecentlytemp(maxDatetime);
/
create table HistoryMsgSubtableData(
	id SERIAL primary key,
	tableName varchar(600),
	startDataTime varchar(600),
	endDataTime number(12),
	currentInsert varchar(600),
	maxId  number(120)
);
/
create table msg_indexupdatelog(
	id SERIAL primary key,
	indextype VARCHAR(24),
	data VARCHAR(700),
	tableName VARCHAR(700),
	dateTime VARCHAR(700)
);
/
create table ofpushlog(
	id SERIAL primary key,
	USERNAME VARCHAR(120) NOT NULL,
	ENTRYSTAMP BIGINT NOT NULL,
	SUMMARY VARCHAR(1200) NOT NULL,
	NODE VARCHAR(1200) NOT NULL,
	DETAILS TEXT
);
/
create index idx_mcl_nm on ofMsgCollect(username);
/
create index idx_mcl_cm on ofMsgCollect(className);
/
create index idx_mcl_ct on ofMsgCollect(createTime); 
/
create table ofpushinfoNew(
	id SERIAL primary key,
	packagename   varchar(600) NOT NULL,
	appName varchar(700)
);
/
ALTER TABLE ofpushdevice ADD userType NVARCHAR(100);
/
create table ofuserMsgSetting(
	id SERIAL primary key,
	userid   varchar(600) NOT NULL,
	targetid varchar(700),
	propValue varchar(120)
);
/
create index idx_oums_ud on ofuserMsgSetting(userid);
/
INSERT INTO ofVersion (name, version) VALUES ('MultiRouterPlugin', 46);
/