CREATE TABLE OFMSGSTATISTICCHATDAY (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  targetId VARCHAR(256),
  targetType VARCHAR(4),
  day VARCHAR(32),
  month      VARCHAR(32),
  year      VARCHAR(32)
);
/
create sequence OFMSGSTATISTICCHATDAY_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger OFMSGSTATISTICCHATDAY_seq_tri
before insert on OFMSGSTATISTICCHATDAY
for each row
begin
select OFMSGSTATISTICCHATDAY_seq.nextval into :new.id from dual;
end;;
/
create index msgstachatday_userId on OFMSGSTATISTICCHATDAY(userId);
/
create index msgstachatday_targetType on OFMSGSTATISTICCHATDAY(targetType);
/
create index msgstachatday_day on OFMSGSTATISTICCHATDAY(day);
/
create index msgstachatday_month on OFMSGSTATISTICCHATDAY(month);
/
create index msgstachatday_year on OFMSGSTATISTICCHATDAY(year);
/
CREATE TABLE OFMSGSTATISTICCHATMONTH (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  month      VARCHAR(32),
  year      VARCHAR(32),
  chatCount int,
  groupChatCount int
);
/
create sequence OFMSGSTATISTICCHATMONTH_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger OFMSGSTATISTTH_seq_tri
before insert on OFMSGSTATISTICCHATMONTH
for each row
begin
select OFMSGSTATISTICCHATMONTH_seq.nextval into :new.id from dual;
end;;
/
create index msgstachatmonth_userId on OFMSGSTATISTICCHATMONTH(userId);
/
create index msgstachatmonth_month on OFMSGSTATISTICCHATMONTH(month);
/
create index msgstachatmonth_year on OFMSGSTATISTICCHATMONTH(year);
/
CREATE TABLE OFMSGSTATISTICCHATYEAR (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  targetType VARCHAR(4),
  year      VARCHAR(32),
  chatCount int,
  groupChatCount int
);
/
create sequence OFMSGSTATISTICCHATYEAR_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger OFMSGSTATISTICCHATYEAR_seq_tri
before insert on OFMSGSTATISTICCHATYEAR
for each row
begin
select OFMSGSTATISTICCHATYEAR_seq.nextval into :new.id from dual;
end;;
/
create index msgstachatyear_userId on OFMSGSTATISTICCHATYEAR(userId);
/
create index msgstachatyear_year on OFMSGSTATISTICCHATYEAR(year);
/
UPDATE ofVersion SET version = 33 WHERE name = 'MultiRouterPlugin';
/