CREATE TABLE ofUser (
  username              VARCHAR2(200)     NOT NULL,
  storedKey             VARCHAR(32),
  serverKey             VARCHAR(32),
  salt                  VARCHAR(32),
  iterations            INTEGER,
  plainPassword         VARCHAR2(32),
  encryptedPassword     VARCHAR2(255),
  name                  VARCHAR2(1000),
  email                 VARCHAR2(100),
  creationDate          CHAR(15)        NOT NULL,
  modificationDate      CHAR(15)        NOT NULL,
  serverUrl varchar(12),
  isExternal varchar(2),
  searchName varchar(1500),
  isTurnover varchar(4),
  CONSTRAINT ofUser_pk PRIMARY KEY (username)
);
/
CREATE INDEX ofUser_cDate_idx ON ofUser (creationDate ASC);
/
CREATE TABLE ofUserProp (
  username              VARCHAR2(64)    NOT NULL,
  name                  VARCHAR2(100)   NOT NULL,
  propValue             VARCHAR2(1024)  NOT NULL,
  CONSTRAINT ofUserProp_pk PRIMARY KEY (username, name)
);
/

CREATE TABLE ofUserFlag (
  username              VARCHAR2(64)    NOT NULL,
  name                  VARCHAR2(100)   NOT NULL,
  startTime             CHAR(15),
  endTime               CHAR(15),
  CONSTRAINT ofUserFlag_pk PRIMARY KEY (username, name)
);
/
CREATE INDEX ofUserFlag_sTime_idx ON ofUserFlag (startTime ASC);
/
CREATE INDEX ofUserFlag_eTime_idx ON ofUserFlag (endTime ASC);
/

CREATE TABLE ofPrivate (
  username              VARCHAR2(64)    NOT NULL,
  name                  VARCHAR2(100)   NOT NULL,
  namespace             VARCHAR2(200)   NOT NULL,
  privateData           clob            NOT NULL,
  CONSTRAINT ofPrivate_pk PRIMARY KEY (username, name, namespace)
);
/

CREATE TABLE ofOffline (
  username              VARCHAR2(64)    NOT NULL,
  messageID             INTEGER         NOT NULL,
  creationDate          CHAR(15)        NOT NULL,
  messageSize           INTEGER         NOT NULL,
  stanza                clob            NOT NULL,
  CONSTRAINT ofOffline_pk PRIMARY KEY (username, messageID)
);

/
CREATE TABLE ofPresence (
  username              VARCHAR2(64)    NOT NULL,
  offlinePresence       clob,
  offlineDate           CHAR(15)        NOT NULL,
  CONSTRAINT ofPresence_pk PRIMARY KEY (username)
);
/

CREATE TABLE ofRoster (
  rosterID              INTEGER         NOT NULL,
  username              VARCHAR2(64)    NOT NULL,
  jid                   VARCHAR2(1024)  NOT NULL,
  sub                   INTEGER         NOT NULL,
  ask                   INTEGER         NOT NULL,
  recv                  INTEGER         NOT NULL,
  nick                  VARCHAR2(255),
  CONSTRAINT ofRoster_pk PRIMARY KEY (rosterID)
);
/
CREATE INDEX ofRoster_username_idx ON ofRoster (username ASC);
/
CREATE INDEX ofRoster_jid_idx ON ofRoster (jid ASC);
/

CREATE TABLE ofRosterGroups (
  rosterID              INTEGER         NOT NULL,
  rank                  INTEGER         NOT NULL,
  groupName             VARCHAR2(255)   NOT NULL,
  CONSTRAINT ofRosterGroups_pk PRIMARY KEY (rosterID, rank)
);
/
CREATE INDEX ofRosterGroup_rosterid_idx ON ofRosterGroups (rosterID ASC);
/
ALTER TABLE ofRosterGroups ADD CONSTRAINT ofRosterGroups_rosterID_fk FOREIGN KEY (rosterID) REFERENCES ofRoster INITIALLY DEFERRED DEFERRABLE;
/

CREATE TABLE ofVCard (
  username              VARCHAR2(64)    NOT NULL,
  vcard                 clob            NOT NULL,
  CONSTRAINT ofVCard_pk PRIMARY KEY (username)
);
/
CREATE TABLE ofGroup (
  groupName             VARCHAR2(50)    NOT NULL,
  description           VARCHAR2(255),
  CONSTRAINT ofGroup_pk PRIMARY KEY (groupName)
);
/
CREATE TABLE ofGroupProp (
  groupName             VARCHAR(50)     NOT NULL,
  name                  VARCHAR2(100)   NOT NULL,
  propValue             VARCHAR2(4000)  NOT NULL,
  CONSTRAINT ofGroupProp_pk PRIMARY KEY (groupName, name)
);
/
CREATE TABLE ofGroupUser (
  groupName             VARCHAR(50)     NOT NULL,
  username              VARCHAR2(100)   NOT NULL,
  administrator         INTEGER         NOT NULL,
  CONSTRAINT ofGroupUser_pk PRIMARY KEY (groupName, username, administrator)
);
/
CREATE TABLE ofID (
  idType                INTEGER         NOT NULL,
  id                    INTEGER         NOT NULL,
  CONSTRAINT ofID_pk PRIMARY KEY (idType)
);
/
CREATE TABLE ofProperty (
  name        VARCHAR2(100) NOT NULL,
  propValue   VARCHAR2(4000) NOT NULL,
  encrypted   INTEGER,
  CONSTRAINT ofProperty_pk PRIMARY KEY (name)
);
/
CREATE TABLE ofVersion (
  name     VARCHAR2(50)  NOT NULL,
  version  INTEGER  NOT NULL,
  CONSTRAINT ofVersion_pk PRIMARY KEY (name)
);
/
CREATE TABLE ofExtComponentConf (
  subdomain             VARCHAR2(255)    NOT NULL,
  wildcard              INTEGER          NOT NULL,
  secret                VARCHAR2(255),
  permission            VARCHAR2(10)     NOT NULL,
  CONSTRAINT ofExtComponentConf_pk PRIMARY KEY (subdomain)
);
/
CREATE TABLE ofRemoteServerConf (
  xmppDomain            VARCHAR2(255)    NOT NULL,
  remotePort            INTEGER,
  permission            VARCHAR2(10)     NOT NULL,
  CONSTRAINT ofRemoteServerConf_pk PRIMARY KEY (xmppDomain)
);
/
CREATE TABLE ofPrivacyList (
  username              VARCHAR2(64)    NOT NULL,
  name                  VARCHAR2(100)   NOT NULL,
  isDefault             INTEGER         NOT NULL,
  list                  clob            NOT NULL,
  CONSTRAINT ofPrivacyList_pk PRIMARY KEY (username, name)
);
/
CREATE INDEX ofPrivacyList_default_idx ON ofPrivacyList (username, isDefault);
/
CREATE TABLE ofSASLAuthorized (
  username            VARCHAR(64)   NOT NULL,
  principal           VARCHAR(4000) NOT NULL,
  CONSTRAINT ofSASLAuthorized_pk PRIMARY KEY (username, principal)
);
/
CREATE TABLE ofSecurityAuditLog (
  msgID                 INTEGER         NOT NULL,
  username              VARCHAR2(64)    NOT NULL,
  entryStamp            bigint         NOT NULL,
  summary               VARCHAR2(255)   NOT NULL,
  node                  VARCHAR2(255)   NOT NULL,
  details               VARCHAR2(4000),
  CONSTRAINT ofSecurityAuditLog_pk PRIMARY KEY (msgID)
);
/
CREATE INDEX ofSecurityAuditLog_tstamp_idx ON ofSecurityAuditLog (entryStamp);
/
CREATE INDEX ofSecurityAuditLog_uname_idx ON ofSecurityAuditLog (username);
/
-- MUC Tables

CREATE TABLE ofMucService (
  serviceID           INT           NOT NULL,
  subdomain           VARCHAR2(255) NOT NULL,
  description         VARCHAR2(255),
  isHidden            INTEGER       NOT NULL,
  CONSTRAINT ofMucService_pk PRIMARY KEY (subdomain)
);
/
CREATE INDEX ofMucService_serviceid_idx ON ofMucService(serviceID);
/
CREATE TABLE ofMucServiceProp (
  serviceID           INT           NOT NULL,
  name                VARCHAR2(100) NOT NULL,
  propValue           VARCHAR2(1024) NOT NULL,
  CONSTRAINT ofMucServiceProp_pk PRIMARY KEY (serviceID, name)
);
/
CREATE TABLE ofMucRoom(
  serviceID           INT           NOT NULL,
  roomID              INT           NOT NULL,
  creationDate        CHAR(15)      NOT NULL,
  modificationDate    CHAR(15)      NOT NULL,
  name                VARCHAR2(50)  NOT NULL,
  naturalName         VARCHAR2(255) NOT NULL,
  description         VARCHAR2(255),
  lockedDate          CHAR(15)      NOT NULL,
  emptyDate           CHAR(15)      NULL,
  canChangeSubject    INTEGER       NOT NULL,
  maxUsers            INTEGER       NOT NULL,
  publicRoom          INTEGER       NOT NULL,
  moderated           INTEGER       NOT NULL,
  membersOnly         INTEGER       NOT NULL,
  canInvite           INTEGER       NOT NULL,
  roomPassword        VARCHAR2(50)  NULL,
  canDiscoverJID      INTEGER       NOT NULL,
  logEnabled          INTEGER       NOT NULL,
  subject             VARCHAR2(100) NULL,
  rolesToBroadcast    INTEGER       NOT NULL,
  useReservedNick     INTEGER       NOT NULL,
  canChangeNick       INTEGER       NOT NULL,
  canRegister         INTEGER       NOT NULL,
  allowpm             INTEGER       NULL,
  CONSTRAINT ofMucRoom_pk PRIMARY KEY (serviceID, name)
);
/
CREATE INDEX ofMucRoom_roomid_idx ON ofMucRoom (roomID);
/
CREATE INDEX ofMucRoom_serviceid_idx ON ofMucRoom (serviceID);
/
CREATE TABLE ofMucRoomProp (
  roomID                INT             NOT NULL,
  name                  VARCHAR2(100)   NOT NULL,
  propValue             VARCHAR2(1024)  NOT NULL,
  CONSTRAINT ofMucRoomProp_pk PRIMARY KEY (roomID, name)
);
/
CREATE TABLE ofMucAffiliation (
  roomID              INT            NOT NULL,
  jid                 VARCHAR2(1024) NOT NULL,
  affiliation         INTEGER        NOT NULL,
  CONSTRAINT ofMucAffiliation_pk PRIMARY KEY (roomID, jid)
);
/
CREATE TABLE ofMucMember (
  roomID              INT            NOT NULL,
  jid                 VARCHAR2(1024) NOT NULL,
  nickname            VARCHAR2(255)  NULL,
  firstName           VARCHAR2(100)  NULL,
  lastName            VARCHAR2(100)  NULL,
  url                 VARCHAR2(100)  NULL,
  email               VARCHAR2(100)  NULL,
  faqentry            VARCHAR2(100)  NULL,
  CONSTRAINT ofMucMember_pk PRIMARY KEY (roomID, jid)
);
/
CREATE TABLE ofMucConversationLog (
  roomID              INT            NOT NULL,
  messageID              INT            NOT NULL,
  sender              VARCHAR2(1024) NOT NULL,
  nickname            VARCHAR2(255)  NULL,
  logTime             CHAR(15)       NOT NULL,
  subject             VARCHAR2(255)  NULL,
  body                VARCHAR2(4000) NULL,
  stanza                VARCHAR2(4000) NULL
);
/
CREATE INDEX ofMucConversationLog_time_idx ON ofMucConversationLog (logTime);
/
CREATE INDEX ofMucConversationLog_msg_id ON ofMucConversationLog (messageID);
/

-- PubSub Tables

CREATE TABLE ofPubsubNode (
  serviceID           VARCHAR2(100)  NOT NULL,
  nodeID              VARCHAR2(100)  NOT NULL,
  leaf                INTEGER        NOT NULL,
  creationDate        CHAR(15)       NOT NULL,
  modificationDate    CHAR(15)       NOT NULL,
  parent              VARCHAR2(100)  NULL,
  deliverPayloads     INTEGER        NOT NULL,
  maxPayloadSize      INTEGER        NULL,
  persistItems        INTEGER        NULL,
  maxItems            INTEGER        NULL,
  notifyConfigChanges INTEGER        NOT NULL,
  notifyDelete        INTEGER        NOT NULL,
  notifyRetract       INTEGER        NOT NULL,
  presenceBased       INTEGER        NOT NULL,
  sendItemSubscribe   INTEGER        NOT NULL,
  publisherModel      VARCHAR2(15)   NOT NULL,
  subscriptionEnabled INTEGER        NOT NULL,
  configSubscription  INTEGER        NOT NULL,
  accessModel         VARCHAR2(10)   NOT NULL,
  payloadType         VARCHAR2(100)  NULL,
  bodyXSLT            VARCHAR2(100)  NULL,
  dataformXSLT        VARCHAR2(100)  NULL,
  creator             VARCHAR2(1024) NOT NULL,
  description         VARCHAR2(255)  NULL,
  language            VARCHAR2(255)  NULL,
  name                VARCHAR2(50)   NULL,
  replyPolicy         VARCHAR2(15)   NULL,
  associationPolicy   VARCHAR2(15)   NULL,
  maxLeafNodes        INTEGER        NULL,
  CONSTRAINT ofPubsubNode_pk PRIMARY KEY (serviceID, nodeID)
);
/
CREATE TABLE ofPubsubNodeJIDs (
  serviceID           VARCHAR2(100)  NOT NULL,
  nodeID              VARCHAR2(100)  NOT NULL,
  jid                 VARCHAR2(1024) NOT NULL,
  associationType     VARCHAR2(20)   NOT NULL,
  CONSTRAINT ofPubsubNodeJIDs_pk PRIMARY KEY (serviceID, nodeID, jid)
);
/
CREATE TABLE ofPubsubNodeGroups (
  serviceID           VARCHAR2(100)  NOT NULL,
  nodeID              VARCHAR2(100)  NOT NULL,
  rosterGroup         VARCHAR2(100)  NOT NULL
);
/
CREATE INDEX ofPubsubNodeGroups_idx ON ofPubsubNodeGroups (serviceID, nodeID);
/
CREATE TABLE ofPubsubAffiliation (
  serviceID           VARCHAR2(100)  NOT NULL,
  nodeID              VARCHAR2(100)  NOT NULL,
  jid                 VARCHAR2(1024) NOT NULL,
  affiliation         VARCHAR2(10)   NOT NULL,
  CONSTRAINT ofPubsubAffiliation_pk PRIMARY KEY (serviceID, nodeID, jid)
);
/
CREATE TABLE ofPubsubItem (
  serviceID           VARCHAR2(100)  NOT NULL,
  nodeID              VARCHAR2(100)  NOT NULL,
  id                  VARCHAR2(100)  NOT NULL,
  jid                 VARCHAR2(1024) NOT NULL,
  creationDate        CHAR(15)       NOT NULL,
  payload             VARCHAR(4000)  NULL,
  CONSTRAINT ofPubsubItem_pk PRIMARY KEY (serviceID, nodeID, id)
);
/
CREATE TABLE ofPubsubSubscription (
  serviceID           VARCHAR2(100)  NOT NULL,
  nodeID              VARCHAR2(100)  NOT NULL,
  id                  VARCHAR2(100)  NOT NULL,
  jid                 VARCHAR2(1024) NOT NULL,
  owner               VARCHAR2(1024) NOT NULL,
  state               VARCHAR(15)    NOT NULL,
  deliver             INTEGER        NOT NULL,
  digest              INTEGER        NOT NULL,
  digest_frequency    INTEGER        NOT NULL,
  expire              CHAR(15)       NULL,
  includeBody         INTEGER        NOT NULL,
  showValues          VARCHAR(30)    NOT NULL,
  subscriptionType    VARCHAR(10)    NOT NULL,
  subscriptionDepth   INTEGER        NOT NULL,
  keyword             VARCHAR2(200)  NULL,
  CONSTRAINT ofPubsubSubscription_pk PRIMARY KEY (serviceID, nodeID, id)
);
/
CREATE TABLE ofPubsubDefaultConf (
  serviceID           VARCHAR2(100) NOT NULL,
  leaf                INTEGER       NOT NULL,
  deliverPayloads     INTEGER       NOT NULL,
  maxPayloadSize      INTEGER       NOT NULL,
  persistItems        INTEGER       NOT NULL,
  maxItems            INTEGER       NOT NULL,
  notifyConfigChanges INTEGER       NOT NULL,
  notifyDelete        INTEGER       NOT NULL,
  notifyRetract       INTEGER       NOT NULL,
  presenceBased       INTEGER       NOT NULL,
  sendItemSubscribe   INTEGER       NOT NULL,
  publisherModel      VARCHAR2(15)  NOT NULL,
  subscriptionEnabled INTEGER       NOT NULL,
  accessModel         VARCHAR2(10)  NOT NULL,
  language            VARCHAR2(255) NULL,
  replyPolicy         VARCHAR2(15)  NULL,
  associationPolicy   VARCHAR2(15)  NOT NULL,
  maxLeafNodes        INTEGER       NOT NULL,
  CONSTRAINT ofPubsubDefaultConf_pk PRIMARY KEY (serviceID, leaf)
);
/
-- Finally, insert default table values.

INSERT INTO ofID (idType, id) VALUES (18, 1);
/
INSERT INTO ofID (idType, id) VALUES (19, 1);
/
INSERT INTO ofID (idType, id) VALUES (23, 1);
/
INSERT INTO ofID (idType, id) VALUES (26, 2);
/
create table SOCIAL_IMCONVERSATION(
	ID             INTEGER,
	USERID         varchar(100),
	TARGETID       VARCHAR2(1000),
	TARGETTYPE     VARCHAR2(1000),
	TARGETPORTRAIT VARCHAR2(1000),
	TARGETNAME     VARCHAR2(1000),
	UNREADCNT      INTEGER,
	ISTOP          CHAR(1),
	LASTTIME       VARCHAR2(1000),
	SENDERID       varchar(100),
	ISOPENFIRE     INTEGER,
	MSGCONTENT     NVARCHAR2(2000)
);
/
create sequence social_IMConversation_id
start with 1
increment by 1
MAXVALUE 9223372036854775807
nocycle ;
/
create or replace trigger social_IMConversation_id_tri
before insert on social_IMConversation
for each row
begin
select social_IMConversation_id.nextval into :new.id from dual;
end;;
/
CREATE TABLE social_IMRecentConver (
	id int ,
	userid varchar(100) NULL ,
	targetid varchar(100) NULL 
);
/
CREATE sequence social_IMRecentConver_id
start with 1
increment by 1
MAXVALUE 9223372036854775807
nocycle;
/
create or replace trigger social_IMRecentConver_id_tri
before insert on social_IMRecentConver
for each row
begin
select social_IMRecentConver_id.nextval into :new.id from dual;
end;;
/
create TABLE social_IMMsgRead(
	ID         INTEGER,
	MSGID      VARCHAR2(100),
	RECEIVERID varchar(100),
	STATUS     INTEGER,
	SENDTIME   CHAR(23),
	USERID     varchar(100)
);
/
create sequence social_IMMsgRead_id
start with 1
increment by 1
MAXVALUE 9223372036854775807
nocycle;
/
create or replace trigger social_IMMsgRead_id_tri
before insert on social_IMMsgRead
for each row
begin
select social_IMMsgRead_id.nextval into :new.id from dual;
end;;
/
CREATE INDEX social_IMMsgRead_index ON social_IMMsgRead(msgid);
/
CREATE INDEX social_IMMR_userid_idx ON social_IMMsgRead(userid);
/
CREATE INDEX social_IMMR_sendtime_idx ON social_IMMsgRead(sendtime);
/
create table HistoryMsg(
	ID         INTEGER PRIMARY KEY,
	FROMUSERID VARCHAR2(1000),
	TARGETID   VARCHAR2(1000),
	TARGETTYPE VARCHAR2(1000),
	GROUPID    VARCHAR2(1000),
	CLASSNAME  VARCHAR2(1000),
	EXTRA      clob,
	TYPE       VARCHAR2(1000),
	IMAGEURI   VARCHAR2(1000),
	DATETIME   VARCHAR2(1000),
	MSGCONTENT clob,
	MSGID      VARCHAR2(100),
	FULLAMOUNT clob
);
/
create sequence HistoryMsg_id
start with 1
increment by 1
MAXVALUE 9223372036854775807
nocycle;
/
create or replace trigger HistoryMsg_id_tri
before insert on HistoryMsg
for each row
begin
select HistoryMsg_id.nextval into :new.id from dual;
end;;
/
CREATE INDEX index_HistoryMsgfromUserId ON HistoryMsg(fromUserId);
/
CREATE INDEX index_HistoryMsgtargetId ON HistoryMsg(targetId);
/
CREATE INDEX index_HistoryMsgGroupId ON HistoryMsg(GroupId);
/
CREATE INDEX index_HistoryMsgdateTime ON HistoryMsg(dateTime);
/
CREATE INDEX index_HistoryMsgmsgid ON HistoryMsg(msgid);
/   
create table Social_historyMsgRight(
	id number(10) primary key,
	userId varchar2(100),
	msgId varchar2(100)
);
/
create sequence SocialHistoryMsgRight_seq 
start with 1 
increment by 1 
MAXVALUE 9223372036854775807 
nocycle;
/
create or replace trigger SocialHistoryMsgRight_seq_tri
before insert on Social_historyMsgRight
for each row
begin
select SocialHistoryMsgRight_seq.nextval into :new.id from dual;
end;;
/
CREATE INDEX historyMsgRight_userid_index ON Social_historyMsgRight (userId);
/
CREATE INDEX historyMsgRight_msgid_index ON Social_historyMsgRight (msgId);
/   
create table MOBILE_DINGRECIVER(
	ID      INTEGER not null,
	DINGID  INTEGER not null,
	USERID  varchar(100) not null,
	CONFIRM VARCHAR2(1000) not null
);
/
create sequence MOBILE_DINGRECIVER_seq 
start with 1 
increment by 1 
MAXVALUE 9223372036854775807 
nocycle ;
/
create or replace trigger MOBILE_DINGRECIVER_seq_tri
before insert on MOBILE_DINGRECIVER
for each row
begin
select MOBILE_DINGRECIVER_seq.nextval into :new.id from dual;
end;;
/
create table MOBILE_DINGREPLY(
	ID           INTEGER not null,
	DINGID       INTEGER not null,
	USERID       varchar(100) not null,
	CONTENT      VARCHAR2(1000),
	OPERATE_DATE VARCHAR2(1000) not null
);
/
create sequence MOBILE_DINGREPLY_seq 
start with 1 
increment by 1 
MAXVALUE 9223372036854775807 
nocycle;
/
create or replace trigger MOBILE_DINGREPLY_seq_tri
before insert on MOBILE_DINGREPLY
for each row
begin
select MOBILE_DINGREPLY_seq.nextval into :new.id from dual;
end;;
/
create table MOBILE_DING(
	ID           INTEGER not null,
	SENDID       varchar(100) not null,
	CONTENT      VARCHAR2(1000),
	SCOPEID      VARCHAR2(1000),
	MESSAGEID    VARCHAR2(1000),
	UDID         VARCHAR2(1000),
	OPERATE_DATE VARCHAR2(1000) not null
);
/
create sequence MOBILE_DING_seq 
start with 1 
increment by 1 
MAXVALUE 9223372036854775807 
nocycle ;
/
create or replace trigger MOBILE_DING_seq_tri
before insert on MOBILE_DING
for each row
begin
select MOBILE_DING_seq.nextval into :new.id from dual;
end;;
/
create table MOBILEPROPERTY(
	NAME      VARCHAR2(1000) primary key,
	PROPVALUE VARCHAR2(1000)
);
/
create table MOBILE_RONGGROUPNOTICE
(
  ID           INTEGER not null,
  TARGETID     VARCHAR2(1000),
  SENDID       varchar(100) not null,
  CONTENT      VARCHAR2(4000),
  OPERATE_DATE VARCHAR2(1000) not null
);
/
create sequence MOBILE_RONGGROUPNOTICE_id
start with 1
increment by 1
MAXVALUE 9223372036854775807
nocycle ;
/
create or replace trigger MOBILE_RONGGROUPNOTICE_id_tri
before insert on MOBILE_RONGGROUPNOTICE
for each row
begin
select MOBILE_RONGGROUPNOTICE_id.nextval into :new.id from dual;
end;;
/
INSERT INTO ofVersion (name, version) VALUES ('openfire', 26);
/
-- Entry for admin user
-- 开启定期修改admin密码
insert into ofProperty(name,propValue) values ('change-password-periodically','true');
/
--密码有效期为 90天
insert into ofProperty(name,propValue) values ('require-change-password-period-seconds','7776000');

/
-- 密码过期后，必须修改密码才可以进入
insert into ofProperty(name,propValue) values ('must-change-password','true');
/
-- 初始密码不允许登录
insert into ofProperty(name,propValue) values ('defaultPassword-login','false');
/
-- 需要生成admin用户，并设置默认密码，默认密码生成到默认文件中
insert into ofProperty(name,propValue) values ('need-set-admin-password','true');
/
-- Entry for default conference service
INSERT INTO ofMucService (serviceID, subdomain, isHidden) VALUES (1, 'conference', 0);
/
commit;
/