
CREATE TABLE ofUser (
  username              VARCHAR(200)     NOT NULL,
  storedKey             VARCHAR(32),
  serverKey             VARCHAR(32),
  salt                  VARCHAR(32),
  iterations            INTEGER,
  plainPassword         VARCHAR(32),
  encryptedPassword     VARCHAR(255),
  name                  VARCHAR(1000),
  email                 VARCHAR(100),
  creationDate          CHAR(15)        NOT NULL,
  modificationDate      CHAR(15)        NOT NULL,
  serverUrl varchar(12),
  isExternal varchar(2),
  searchName varchar(1500),
  isTurnover varchar(4),
  PRIMARY KEY (username),
  INDEX ofUser_cDate_idx (creationDate)
);
/
CREATE TABLE ofUserProp (
  username              VARCHAR(64)     NOT NULL,
  name                  VARCHAR(100)    NOT NULL,
  propValue             TEXT            NOT NULL,
  PRIMARY KEY (username, name)
);
/
CREATE TABLE ofUserFlag (
  username              VARCHAR(64)     NOT NULL,
  name                  VARCHAR(100)    NOT NULL,
  startTime             CHAR(15),
  endTime               CHAR(15),
  PRIMARY KEY (username, name),
  INDEX ofUserFlag_sTime_idx (startTime),
  INDEX ofUserFlag_eTime_idx (endTime)
);
/
CREATE TABLE ofPrivate (
  username              VARCHAR(64)     NOT NULL,
  name                  VARCHAR(100)    NOT NULL,
  namespace             VARCHAR(200)    NOT NULL,
  privateData           TEXT            NOT NULL,
  PRIMARY KEY (username, name)
);
/
CREATE TABLE ofOffline (
  username              VARCHAR(64)     NOT NULL,
  messageID             BIGINT          NOT NULL,
  creationDate          CHAR(15)        NOT NULL,
  messageSize           INTEGER         NOT NULL,
  stanza                TEXT            NOT NULL,
  PRIMARY KEY (username, messageID)
);
/
CREATE TABLE ofPresence (
  username              VARCHAR(64)     NOT NULL,
  offlinePresence       TEXT,
  offlineDate           CHAR(15)     NOT NULL,
  PRIMARY KEY (username)
);
/
CREATE TABLE ofRoster (
  rosterID              BIGINT          NOT NULL,
  username              VARCHAR(64)     NOT NULL,
  jid                   VARCHAR(1024)   NOT NULL,
  sub                   TINYINT         NOT NULL,
  ask                   TINYINT         NOT NULL,
  recv                  TINYINT         NOT NULL,
  nick                  VARCHAR(255),
  PRIMARY KEY (rosterID),
  INDEX ofRoster_unameid_idx (username)
);
/
CREATE TABLE ofRosterGroups (
  rosterID              BIGINT          NOT NULL,
  `rank`                TINYINT         NOT NULL,
  groupName             VARCHAR(255)    NOT NULL,
  PRIMARY KEY (rosterID, `rank`),
  INDEX ofRosterGroup_rosterid_idx (rosterID)
);
/
CREATE TABLE ofVCard (
  username              VARCHAR(64)     NOT NULL,
  vcard                 MEDIUMTEXT      NOT NULL,
  PRIMARY KEY (username)
);
/
CREATE TABLE ofGroup (
  groupName             VARCHAR(50)     NOT NULL,
  description           VARCHAR(255),
  PRIMARY KEY (groupName)
);
/
CREATE TABLE ofGroupProp (
  groupName             VARCHAR(50)     NOT NULL,
  name                  VARCHAR(100)    NOT NULL,
  propValue             TEXT            NOT NULL,
  PRIMARY KEY (groupName, name)
);
/
CREATE TABLE ofGroupUser (
  groupName             VARCHAR(50)     NOT NULL,
  username              VARCHAR(100)    NOT NULL,
  administrator         TINYINT         NOT NULL,
  PRIMARY KEY (groupName, username, administrator)
);
/
CREATE TABLE ofID (
  idType                INTEGER         NOT NULL,
  id                    BIGINT          NOT NULL,
  PRIMARY KEY (idType)
);
/
CREATE TABLE ofProperty (
  name        VARCHAR(100)              NOT NULL,
  propValue   TEXT                      NOT NULL,
  encrypted   INTEGER,
  PRIMARY KEY (name)
);
/

CREATE TABLE ofVersion (
  name     VARCHAR(50)  NOT NULL,
  version  INTEGER  NOT NULL,
  PRIMARY KEY (name)
);
/
CREATE TABLE ofExtComponentConf (
  subdomain             VARCHAR(255)    NOT NULL,
  wildcard              TINYINT         NOT NULL,
  secret                VARCHAR(255),
  permission            VARCHAR(10)     NOT NULL,
  PRIMARY KEY (subdomain)
);
/
CREATE TABLE ofRemoteServerConf (
  xmppDomain            VARCHAR(255)    NOT NULL,
  remotePort            INTEGER,
  permission            VARCHAR(10)     NOT NULL,
  PRIMARY KEY (xmppDomain)
);
/
CREATE TABLE ofPrivacyList (
  username              VARCHAR(64)     NOT NULL,
  name                  VARCHAR(100)    NOT NULL,
  isDefault             TINYINT         NOT NULL,
  list                  TEXT            NOT NULL,
  PRIMARY KEY (username, name),
  INDEX ofPrivacyList_default_idx (username, isDefault)
);
/
CREATE TABLE ofSASLAuthorized (
  username            VARCHAR(64)   NOT NULL,
  principal           TEXT          NOT NULL,
  PRIMARY KEY (username)
);
/
CREATE TABLE ofSecurityAuditLog (
  msgID                 BIGINT          NOT NULL,
  username              VARCHAR(64)     NOT NULL,
  entryStamp            BIGINT          NOT NULL,
  summary               VARCHAR(255)    NOT NULL,
  node                  VARCHAR(255)    NOT NULL,
  details               TEXT,
  PRIMARY KEY (msgID),
  INDEX ofSecurityAuditLog_tstamp_idx (entryStamp),
  INDEX ofSecurityAuditLog_uname_idx (username)
);
/
# MUC Tables

CREATE TABLE ofMucService (
  serviceID           BIGINT        NOT NULL,
  subdomain           VARCHAR(255)  NOT NULL,
  description         VARCHAR(255),
  isHidden            TINYINT       NOT NULL,
  PRIMARY KEY (subdomain),
  INDEX ofMucService_serviceid_idx (serviceID)
);
/
CREATE TABLE ofMucServiceProp (
  serviceID           BIGINT        NOT NULL,
  name                VARCHAR(100)  NOT NULL,
  propValue           TEXT          NOT NULL,
  PRIMARY KEY (serviceID, name)
);
/
CREATE TABLE ofMucRoom (
  serviceID           BIGINT        NOT NULL,
  roomID              BIGINT        NOT NULL,
  creationDate        CHAR(15)      NOT NULL,
  modificationDate    CHAR(15)      NOT NULL,
  name                VARCHAR(50)   NOT NULL,
  naturalName         VARCHAR(255)  NOT NULL,
  description         VARCHAR(255),
  lockedDate          CHAR(15)      NOT NULL,
  emptyDate           CHAR(15)      NULL,
  canChangeSubject    TINYINT       NOT NULL,
  maxUsers            INTEGER       NOT NULL,
  publicRoom          TINYINT       NOT NULL,
  moderated           TINYINT       NOT NULL,
  membersOnly         TINYINT       NOT NULL,
  canInvite           TINYINT       NOT NULL,
  roomPassword        VARCHAR(50)   NULL,
  canDiscoverJID      TINYINT       NOT NULL,
  logEnabled          TINYINT       NOT NULL,
  subject             VARCHAR(100)  NULL,
  rolesToBroadcast    TINYINT       NOT NULL,
  useReservedNick     TINYINT       NOT NULL,
  canChangeNick       TINYINT       NOT NULL,
  canRegister         TINYINT       NOT NULL,
  allowpm             TINYINT       NULL,
  PRIMARY KEY (serviceID,name),
  INDEX ofMucRoom_roomid_idx (roomID),
  INDEX ofMucRoom_serviceid_idx (serviceID)
);
/
CREATE TABLE ofMucRoomProp (
  roomID                BIGINT          NOT NULL,
  name                  VARCHAR(100)    NOT NULL,
  propValue             TEXT            NOT NULL,
  PRIMARY KEY (roomID, name)
);
/
CREATE TABLE ofMucAffiliation (
  roomID              BIGINT        NOT NULL,
  jid                 TEXT          NOT NULL,
  affiliation         TINYINT       NOT NULL,
  PRIMARY KEY (roomID)
);
/
CREATE TABLE ofMucMember (
  roomID              BIGINT        NOT NULL,
  jid                 TEXT          NOT NULL,
  nickname            VARCHAR(255)  NULL,
  firstName           VARCHAR(100)  NULL,
  lastName            VARCHAR(100)  NULL,
  url                 VARCHAR(100)  NULL,
  email               VARCHAR(100)  NULL,
  faqentry            VARCHAR(100)  NULL,
  PRIMARY KEY (roomID)
);
/
CREATE TABLE ofMucConversationLog (
  roomID              BIGINT        NOT NULL,
  messageID        BIGINT     NOT NULL,
  sender              TEXT          NOT NULL,
  nickname            VARCHAR(255)  NULL,
  logTime             CHAR(15)      NOT NULL,
  subject             VARCHAR(255)  NULL,
  body                TEXT          NULL,
  stanza                TEXT          NULL,
  INDEX ofMucConversationLog_time_idx (logTime),
  INDEX ofMucConversationLog_msg_id (messageID)
);
/
# PubSub Tables

CREATE TABLE ofPubsubNode (
  serviceID           VARCHAR(100)  NOT NULL,
  nodeID              VARCHAR(100)  NOT NULL,
  leaf                TINYINT       NOT NULL,
  creationDate        CHAR(15)      NOT NULL,
  modificationDate    CHAR(15)      NOT NULL,
  parent              VARCHAR(100)  NULL,
  deliverPayloads     TINYINT       NOT NULL,
  maxPayloadSize      INTEGER       NULL,
  persistItems        TINYINT       NULL,
  maxItems            INTEGER       NULL,
  notifyConfigChanges TINYINT       NOT NULL,
  notifyDelete        TINYINT       NOT NULL,
  notifyRetract       TINYINT       NOT NULL,
  presenceBased       TINYINT       NOT NULL,
  sendItemSubscribe   TINYINT       NOT NULL,
  publisherModel      VARCHAR(15)   NOT NULL,
  subscriptionEnabled TINYINT       NOT NULL,
  configSubscription  TINYINT       NOT NULL,
  accessModel         VARCHAR(10)   NOT NULL,
  payloadType         VARCHAR(100)  NULL,
  bodyXSLT            VARCHAR(100)  NULL,
  dataformXSLT        VARCHAR(100)  NULL,
  creator             VARCHAR(255) NOT NULL,
  description         VARCHAR(255)  NULL,
  language            VARCHAR(255)  NULL,
  name                VARCHAR(50)   NULL,
  replyPolicy         VARCHAR(15)   NULL,
  associationPolicy   VARCHAR(15)   NULL,
  maxLeafNodes        INTEGER       NULL,
  PRIMARY KEY (serviceID, nodeID)
);
/
CREATE TABLE ofPubsubNodeJIDs (
  serviceID           VARCHAR(100)  NOT NULL,
  nodeID              VARCHAR(100)  NOT NULL,
  jid                 VARCHAR(255)  NOT NULL,
  associationType     VARCHAR(20)   NOT NULL,
  PRIMARY KEY (serviceID, nodeID)
);
/
CREATE TABLE ofPubsubNodeGroups (
  serviceID           VARCHAR(100)  NOT NULL,
  nodeID              VARCHAR(100)  NOT NULL,
  rosterGroup         VARCHAR(100)   NOT NULL,
  INDEX ofPubsubNodeGroups_idx (serviceID, nodeID)
);
/
CREATE TABLE ofPubsubAffiliation (
  serviceID           VARCHAR(100)  NOT NULL,
  nodeID              VARCHAR(100)  NOT NULL,
  jid                 VARCHAR(255) NOT NULL,
  affiliation         VARCHAR(10)   NOT NULL,
  PRIMARY KEY (serviceID, nodeID)
);
/
CREATE TABLE ofPubsubItem (
  serviceID           VARCHAR(100)  NOT NULL,
  nodeID              VARCHAR(100)  NOT NULL,
  id                  VARCHAR(100)  NOT NULL,
  jid                 VARCHAR(255)  NOT NULL,
  creationDate        CHAR(15)      NOT NULL,
  payload             MEDIUMTEXT    NULL,
  PRIMARY KEY (serviceID, nodeID, id)
);
/
CREATE TABLE ofPubsubSubscription (
  serviceID           VARCHAR(100)  NOT NULL,
  nodeID              VARCHAR(100)  NOT NULL,
  id                  VARCHAR(100)  NOT NULL,
  jid                 VARCHAR(255) NOT NULL,
  owner               VARCHAR(255) NOT NULL,
  state               VARCHAR(15)   NOT NULL,
  deliver             TINYINT       NOT NULL,
  digest              TINYINT       NOT NULL,
  digest_frequency    INT           NOT NULL,
  expire              CHAR(15)      NULL,
  includeBody         TINYINT       NOT NULL,
  showValues          VARCHAR(30)   NULL,
  subscriptionType    VARCHAR(10)   NOT NULL,
  subscriptionDepth   TINYINT       NOT NULL,
  keyword             VARCHAR(200)  NULL,
  PRIMARY KEY (serviceID, nodeID, id)
);
/
CREATE TABLE ofPubsubDefaultConf (
  serviceID           VARCHAR(100)  NOT NULL,
  leaf                TINYINT       NOT NULL,
  deliverPayloads     TINYINT       NOT NULL,
  maxPayloadSize      INTEGER       NOT NULL,
  persistItems        TINYINT       NOT NULL,
  maxItems            INTEGER       NOT NULL,
  notifyConfigChanges TINYINT       NOT NULL,
  notifyDelete        TINYINT       NOT NULL,
  notifyRetract       TINYINT       NOT NULL,
  presenceBased       TINYINT       NOT NULL,
  sendItemSubscribe   TINYINT       NOT NULL,
  publisherModel      VARCHAR(15)   NOT NULL,
  subscriptionEnabled TINYINT       NOT NULL,
  accessModel         VARCHAR(10)   NOT NULL,
  language            VARCHAR(255)  NULL,
  replyPolicy         VARCHAR(15)   NULL,
  associationPolicy   VARCHAR(15)   NOT NULL,
  maxLeafNodes        INTEGER       NOT NULL,
  PRIMARY KEY (serviceID, leaf)
);
/
# Finally, insert default table values.

INSERT INTO ofID (idType, id) VALUES (18, 1);
/
INSERT INTO ofID (idType, id) VALUES (19, 1);
/
INSERT INTO ofID (idType, id) VALUES (23, 1);
/
INSERT INTO ofID (idType, id) VALUES (26, 2);
/

CREATE TABLE social_IMMsgRead (
	id int NOT NULL PRIMARY Key  auto_increment ,
	msgid varchar(100) NULL ,
	receiverid varchar(100) NULL ,
	status int NULL ,
	sendtime char(23) NULL ,
	userid varchar(100) NULL ,
	index(msgid)
);
/
CREATE INDEX social_IMMsgRead_index ON social_IMMsgRead(msgid) ;
/
CREATE INDEX social_IMMR_userid_idx ON social_IMMsgRead(userid) ;
/
CREATE INDEX social_IMMR_sendtime_idx ON social_IMMsgRead(sendtime);
/
CREATE TABLE social_IMRecentConver (
	id int NOT NULL auto_increment primary key,
	userid varchar(100) NULL ,
	targetid varchar(100) NULL 
);
/
CREATE TABLE  HistoryMsg (
	id int NOT NULL auto_increment Primary key,
	fromUserId varchar(100) NULL ,
	targetId varchar(100) NULL ,
	targetType varchar(100) NULL ,
	GroupId varchar(100) NULL ,
	classname varchar(100) NULL ,
	msgContentBak text NULL ,
	extra text NULL ,
	type varchar(100) NULL ,
	imageUri varchar(100) NULL ,
	dateTime varchar(100) NULL ,
	msgid varchar(100) NULL ,
	msgContent text NULL ,
	fullAmount text NULL 
);
/
CREATE INDEX index_HistoryMsgfromUserId ON HistoryMsg(fromUserId);
/
CREATE INDEX index_HistoryMsgtargetId ON HistoryMsg(targetId);
/
CREATE INDEX index_HistoryMsgGroupId ON HistoryMsg(GroupId);
/
CREATE INDEX index_HistoryMsgdateTime ON HistoryMsg(dateTime);
/
CREATE INDEX index_HistoryMsgmsgid ON HistoryMsg(msgid);
/

CREATE TABLE mobile_ding (
	id int NOT NULL auto_increment primary key ,
	sendid varchar(100) NOT NULL ,
	content varchar(1000) NULL ,
	scopeid varchar(100) NULL ,
	messageid varchar(100) NULL ,
	udid varchar(100) NULL ,
	operate_date char(20) NOT NULL
);
/
CREATE TABLE mobile_dingReciver (
	id int NOT NULL auto_increment primary key ,
	dingid int NOT NULL ,
	userid varchar(100) NOT NULL ,
	confirm char(20) NOT NULL 
);
/
CREATE TABLE mobile_dingReply (
	id int NOT NULL auto_increment primary key,
	dingid int NOT NULL ,
	userid varchar(100) NOT NULL ,
	content varchar(1000) NULL ,
	operate_date char(20) NOT NULL 
);
/
CREATE TABLE mobileProperty (
	name varchar(100) NOT NULL PRIMARY KEY ,
	propValue varchar(100) NULL 
);
/
CREATE TABLE Social_historyMsgRight (
	id int NOT NULL auto_increment PRIMARY KEY ,
	userId varchar(100) NULL ,
	msgId varchar(100) NULL
);
/
CREATE INDEX historyMsgRight_userid_index ON Social_historyMsgRight(userId);
/
CREATE INDEX historyMsgRight_msgid_index ON Social_historyMsgRight(msgId);
/
CREATE TABLE social_IMConversation (
	id int NOT NULL auto_increment PRIMARY key ,
	userid varchar(100) NULL ,
	targetid varchar(100) NULL ,
	targettype varchar(20) NULL ,
	targetPortrait varchar(100) NULL ,
	targetname varchar(100) NULL ,
	unreadcnt int NULL ,
	istop char(1) NULL ,
	lasttime varchar(100) NULL ,
	senderid varchar(100) NULL ,
	isopenfire int NULL ,
	msgcontent VARCHAR(4000) NULL
);
/
CREATE TABLE mobile_rongGroupNotice ( 
	  id int NOT NULL auto_increment primary key,
	  targetid varchar(100) NULL,  
	  sendid varchar(100) NULL,
	  content varchar(4000) NULL,
	  operate_date char(50) NOT NULL 
);
/
-- Entry for admin user
-- 开启定期修改admin密码
insert into ofProperty(name,propValue) values ('change-password-periodically','true');
/
--密码有效期为 90天
insert into ofProperty(name,propValue) values ('require-change-password-period-seconds','7776000');

/
-- 密码过期后，必须修改密码才可以进入
insert into ofProperty(name,propValue) values ('must-change-password','true');
/
-- 初始密码不允许登录
insert into ofProperty(name,propValue) values ('defaultPassword-login','false');
/
-- 需要生成admin用户，并设置默认密码，默认密码生成到默认文件中
insert into ofProperty(name,propValue) values ('need-set-admin-password','true');
/
# Entry for default conference service
INSERT INTO ofMucService (serviceID, subdomain, isHidden) VALUES (1, 'conference', 0);
/
INSERT INTO ofVersion (name, version) VALUES ('openfire', 26);
/