CREATE TABLE OFUSER (
	USERNAME VARCHAR(1000) NOT NULL,
	STOREDKEY VARCHAR(200) DEFAULT NULL,
	SERVERKEY VARCHAR(200) DEFAULT NULL,
	SALT VARCHAR(200) DEFAULT NULL,
	ITERATIONS INT DEFAULT NULL,
	PLAINPASSWORD VARCHAR(200) DEFAULT NULL,
	ENCRYPTEDPASSWORD VARCHAR(1000) DEFAULT NULL,
	NAME VARCHAR(1500) DEFAULT NULL,
	EMAIL VARCHAR(600) DEFAULT NULL,
	CREATIONDATE CHAR(100) NOT NULL,
	MODIFICATIONDATE CHAR(100) NOT NULL,
	ISTURNOVER VARCHAR(12) DEFAULT NULL,
	serverUrl varchar(80),
        isExternal varchar(10),
        searchName varchar(2000),
	PRIMARY KEY (USERNAME)
);
/
CREATE TABLE OFUSERPROP (
	USERNAME VARCHAR(64) NOT NULL,
	NAME VARCHAR(100) NOT NULL,
	PROPVALUE TEXT NOT NULL,
	PRIMARY KEY (USERNAME, NAME)
);
/
CREATE TABLE OFUSERFLAG (
	USERNAME VARCHAR(64) NOT NULL,
	NAME VARCHAR(100) NOT NULL,
	STARTTIME CHAR(15) DEFAULT NULL,
	ENDTIME CHAR(15) DEFAULT NULL,
	PRIMARY KEY (USERNAME, NAME)
);
/
CREATE TABLE OFPRIVATE (
	USERNAME VARCHAR(64) NOT NULL,
	NAME VARCHAR(100) NOT NULL,
	NAMESPACE VARCHAR(200) NOT NULL,
	PRIVATEDATA TEXT NOT NULL,
	PRIMARY KEY (USERNAME, NAME, NAMESPACE)
);
/
CREATE TABLE OFOFFLINE (
	USERNAME VARCHAR(64) NOT NULL,
	MESSAGEID BIGINT NOT NULL,
	CREATIONDATE CHAR(15) NOT NULL,
	MESSAGESIZE INT NOT NULL,
	STANZA TEXT NOT NULL,
	PRIMARY KEY (USERNAME, MESSAGEID)
);
/
CREATE TABLE OFPRESENCE (
	USERNAME VARCHAR(64) NOT NULL,
	OFFLINEPRESENCE TEXT,
	OFFLINEDATE CHAR(15) NOT NULL,
	PRIMARY KEY (USERNAME)
);
/
CREATE TABLE OFROSTER (
	ROSTERID BIGINT NOT NULL,
	USERNAME VARCHAR(64) NOT NULL,
	JID VARCHAR(1024) NOT NULL,
	SUB SMALLINT NOT NULL,
	ASK SMALLINT NOT NULL,
	RECV SMALLINT NOT NULL,
	NICK VARCHAR(255) DEFAULT NULL,
	PRIMARY KEY (ROSTERID)
);
/
CREATE TABLE OFROSTERGROUPS (
	ROSTERID BIGINT NOT NULL,
	RANK SMALLINT NOT NULL,
	GROUPNAME VARCHAR(255) NOT NULL,
	PRIMARY KEY (ROSTERID, RANK)
);
/
CREATE TABLE OFVCARD (
	USERNAME VARCHAR(64) NOT NULL,
	VCARD TEXT NOT NULL,
	PRIMARY KEY (USERNAME)
);
/
CREATE TABLE OFGROUP (
	GROUPNAME VARCHAR(300) NOT NULL,
	DESCRIPTION VARCHAR(1000) DEFAULT NULL,
	GROUPICONURL VARCHAR(600) DEFAULT NULL,
	ISDISABLEMSGREAD VARCHAR(60) DEFAULT NULL,
	ISDISABLEWORDS VARCHAR(60) DEFAULT NULL,
	ISDISABLEADDUSER VARCHAR(60) DEFAULT NULL,
	CREATEUSER VARCHAR(800) DEFAULT NULL,
	GROUPMANAGERS VARCHAR(4000) DEFAULT NULL,
	DELETEGROUP VARCHAR(60) DEFAULT NULL,
	CREATETIME VARCHAR(300) DEFAULT NULL,
	GROUPICONTYPE VARCHAR(60) DEFAULT NULL,
	GROUPICONUSERIDS VARCHAR(200) DEFAULT NULL,
	SEEHISTORYMSG VARCHAR(200) DEFAULT NULL,
	ISDRCODEADDGROUPUSER VARCHAR(80) DEFAULT NULL,
	ISCOMMONMEMBERSADDGROUPUSER VARCHAR(60) DEFAULT NULL,
	GROUPTYPE VARCHAR(60) DEFAULT NULL,
	ISTOP VARCHAR(10) DEFAULT NULL,
	MAXGROUPMEMBER VARCHAR(60) DEFAULT NULL,
	SECRETGROUPTYPE VARCHAR(30) DEFAULT NULL,
	PRIMARY KEY (GROUPNAME)
);
/
CREATE TABLE OFGROUPPROP (
	GROUPNAME VARCHAR(50) NOT NULL,
	NAME VARCHAR(100) NOT NULL,
	PROPVALUE TEXT NOT NULL,
	PRIMARY KEY (GROUPNAME, NAME)
);
/
CREATE TABLE OFGROUPUSER (
	GROUPNAME VARCHAR(50) NOT NULL,
	USERNAME VARCHAR(100) NOT NULL,
	ADMINISTRATOR SMALLINT NOT NULL,
	LASTTIME VARCHAR(100) DEFAULT NULL,
	ISDEL VARCHAR(4) DEFAULT NULL,
	PRIMARY KEY (GROUPNAME, USERNAME, ADMINISTRATOR)
);
/
CREATE TABLE OFID (
	IDTYPE INT NOT NULL,
	ID BIGINT NOT NULL,
	PRIMARY KEY (IDTYPE)
);
/
CREATE TABLE OFPROPERTY (
	NAME VARCHAR(600) NOT NULL,
	PROPVALUE TEXT NOT NULL,
	ENCRYPTED INT DEFAULT NULL,
	PRIMARY KEY (NAME)
);
/
CREATE TABLE OFVERSION (
	NAME VARCHAR(300) NOT NULL,
	VERSION INT NOT NULL,
	PRIMARY KEY (NAME)
);
/
CREATE TABLE OFEXTCOMPONENTCONF (
	SUBDOMAIN VARCHAR(255) NOT NULL,
	WILDCARD SMALLINT NOT NULL,
	SECRET VARCHAR(255) DEFAULT NULL,
	PERMISSION VARCHAR(10) NOT NULL,
	PRIMARY KEY (SUBDOMAIN)
);
/
CREATE TABLE OFREMOTESERVERCONF (
	XMPPDOMAIN VARCHAR(255) NOT NULL,
	REMOTEPORT INT DEFAULT NULL,
	PERMISSION VARCHAR(10) NOT NULL,
	PRIMARY KEY (XMPPDOMAIN)
);
/
CREATE TABLE OFPRIVACYLIST (
	USERNAME VARCHAR(64) NOT NULL,
	NAME VARCHAR(100) NOT NULL,
	ISDEFAULT SMALLINT NOT NULL,
	LIST TEXT NOT NULL,
	PRIMARY KEY (USERNAME, NAME)
);
/
CREATE TABLE OFSASLAUTHORIZED (
	USERNAME VARCHAR(400) NOT NULL,
	PRINCIPAL TEXT NOT NULL,
	PRIMARY KEY (USERNAME, PRINCIPAL)
);
/
CREATE TABLE OFSECURITYAUDITLOG (
	MSGID BIGINT NOT NULL,
	USERNAME VARCHAR(300) NOT NULL,
	ENTRYSTAMP BIGINT NOT NULL,
	SUMMARY VARCHAR(1200) NOT NULL,
	NODE VARCHAR(1200) NOT NULL,
	DETAILS TEXT,
	PRIMARY KEY (MSGID)
);
/
CREATE TABLE OFMUCSERVICE (
	SERVICEID BIGINT NOT NULL,
	SUBDOMAIN VARCHAR(1200) NOT NULL,
	DESCRIPTION VARCHAR(1200) DEFAULT NULL,
	ISHIDDEN SMALLINT NOT NULL,
	PRIMARY KEY (SUBDOMAIN)
);
/
CREATE TABLE OFMUCSERVICEPROP (
	SERVICEID BIGINT NOT NULL,
	NAME VARCHAR(100) NOT NULL,
	PROPVALUE TEXT NOT NULL,
	PRIMARY KEY (SERVICEID, NAME)
);
/
CREATE TABLE OFMUCROOM (
	SERVICEID BIGINT NOT NULL,
	ROOMID BIGINT NOT NULL,
	CREATIONDATE CHAR(15) NOT NULL,
	MODIFICATIONDATE CHAR(15) NOT NULL,
	NAME VARCHAR(50) NOT NULL,
	NATURALNAME VARCHAR(255) NOT NULL,
	DESCRIPTION VARCHAR(255) DEFAULT NULL,
	LOCKEDDATE CHAR(15) NOT NULL,
	EMPTYDATE CHAR(15) DEFAULT NULL,
	CANCHANGESUBJECT SMALLINT NOT NULL,
	MAXUSERS INT NOT NULL,
	PUBLICROOM SMALLINT NOT NULL,
	MODERATED SMALLINT NOT NULL,
	MEMBERSONLY SMALLINT NOT NULL,
	CANINVITE SMALLINT NOT NULL,
	ROOMPASSWORD VARCHAR(50) DEFAULT NULL,
	CANDISCOVERJID SMALLINT NOT NULL,
	LOGENABLED SMALLINT NOT NULL,
	SUBJECT VARCHAR(100) DEFAULT NULL,
	ROLESTOBROADCAST SMALLINT NOT NULL,
	USERESERVEDNICK SMALLINT NOT NULL,
	CANCHANGENICK SMALLINT NOT NULL,
	CANREGISTER SMALLINT NOT NULL,
	ALLOWPM SMALLINT DEFAULT NULL,
	PRIMARY KEY (SERVICEID, NAME)
);
/
CREATE TABLE OFMUCROOMPROP (
	ROOMID BIGINT NOT NULL,
	NAME VARCHAR(100) NOT NULL,
	PROPVALUE TEXT NOT NULL,
	PRIMARY KEY (ROOMID, NAME)
);
/
CREATE TABLE OFMUCAFFILIATION (
	ROOMID BIGINT NOT NULL,
	JID TEXT NOT NULL,
	AFFILIATION SMALLINT NOT NULL,
	PRIMARY KEY (ROOMID, JID)
);
/
CREATE TABLE OFMUCMEMBER (
	ROOMID BIGINT NOT NULL,
	JID TEXT NOT NULL,
	NICKNAME VARCHAR(255) DEFAULT NULL,
	FIRSTNAME VARCHAR(100) DEFAULT NULL,
	LASTNAME VARCHAR(100) DEFAULT NULL,
	URL VARCHAR(100) DEFAULT NULL,
	EMAIL VARCHAR(100) DEFAULT NULL,
	FAQENTRY VARCHAR(100) DEFAULT NULL,
	PRIMARY KEY (ROOMID, JID)
);
/
CREATE TABLE OFMUCCONVERSATIONLOG (
	ROOMID BIGINT NOT NULL,
	MESSAGEID BIGINT NOT NULL,
	SENDER TEXT NOT NULL,
	NICKNAME VARCHAR(255) DEFAULT NULL,
	LOGTIME CHAR(15) NOT NULL,
	SUBJECT VARCHAR(255) DEFAULT NULL,
	BODY TEXT,
	STANZA TEXT
);
/
CREATE TABLE OFPUBSUBNODE (
	SERVICEID VARCHAR(100) NOT NULL,
	NODEID VARCHAR(100) NOT NULL,
	LEAF SMALLINT NOT NULL,
	CREATIONDATE CHAR(15) NOT NULL,
	MODIFICATIONDATE CHAR(15) NOT NULL,
	PARENT VARCHAR(100) DEFAULT NULL,
	DELIVERPAYLOADS SMALLINT NOT NULL,
	MAXPAYLOADSIZE INT DEFAULT NULL,
	PERSISTITEMS SMALLINT DEFAULT NULL,
	MAXITEMS INT DEFAULT NULL,
	NOTIFYCONFIGCHANGES SMALLINT NOT NULL,
	NOTIFYDELETE SMALLINT NOT NULL,
	NOTIFYRETRACT SMALLINT NOT NULL,
	PRESENCEBASED SMALLINT NOT NULL,
	SENDITEMSUBSCRIBE SMALLINT NOT NULL,
	PUBLISHERMODEL VARCHAR(15) NOT NULL,
	SUBSCRIPTIONENABLED SMALLINT NOT NULL,
	CONFIGSUBSCRIPTION SMALLINT NOT NULL,
	ACCESSMODEL VARCHAR(10) NOT NULL,
	PAYLOADTYPE VARCHAR(100) DEFAULT NULL,
	BODYXSLT VARCHAR(100) DEFAULT NULL,
	DATAFORMXSLT VARCHAR(100) DEFAULT NULL,
	CREATOR VARCHAR(255) NOT NULL,
	DESCRIPTION VARCHAR(255) DEFAULT NULL,
	LANGUAGE VARCHAR(255) DEFAULT NULL,
	NAME VARCHAR(50) DEFAULT NULL,
	REPLYPOLICY VARCHAR(15) DEFAULT NULL,
	ASSOCIATIONPOLICY VARCHAR(15) DEFAULT NULL,
	MAXLEAFNODES INT DEFAULT NULL,
	PRIMARY KEY (SERVICEID, NODEID)
);
/
CREATE TABLE OFPUBSUBNODEJIDS (
	SERVICEID VARCHAR(100) NOT NULL,
	NODEID VARCHAR(100) NOT NULL,
	JID VARCHAR(255) NOT NULL,
	ASSOCIATIONTYPE VARCHAR(20) NOT NULL,
	PRIMARY KEY (SERVICEID, NODEID, JID)
);
/
CREATE TABLE OFPUBSUBNODEGROUPS (
	SERVICEID VARCHAR(100) NOT NULL,
	NODEID VARCHAR(100) NOT NULL,
	ROSTERGROUP VARCHAR(100) NOT NULL
);
/
CREATE TABLE OFPUBSUBAFFILIATION (
	SERVICEID VARCHAR(100) NOT NULL,
	NODEID VARCHAR(100) NOT NULL,
	JID VARCHAR(255) NOT NULL,
	AFFILIATION VARCHAR(10) NOT NULL,
	PRIMARY KEY (SERVICEID, NODEID, JID)
);
/
CREATE TABLE OFPUBSUBITEM (
	SERVICEID VARCHAR(100) NOT NULL,
	NODEID VARCHAR(100) NOT NULL,
	ID VARCHAR(100) NOT NULL,
	JID VARCHAR(255) NOT NULL,
	CREATIONDATE CHAR(15) NOT NULL,
	PAYLOAD TEXT,
	PRIMARY KEY (SERVICEID, NODEID, ID)
);
/
CREATE TABLE OFPUBSUBSUBSCRIPTION (
	SERVICEID VARCHAR(100) NOT NULL,
	NODEID VARCHAR(100) NOT NULL,
	ID VARCHAR(100) NOT NULL,
	JID VARCHAR(255) NOT NULL,
	OWNER VARCHAR(255) NOT NULL,
	STATE VARCHAR(15) NOT NULL,
	DELIVER SMALLINT NOT NULL,
	DIGEST SMALLINT NOT NULL,
	DIGEST_FREQUENCY INT NOT NULL,
	EXPIRE CHAR(15) DEFAULT NULL,
	INCLUDEBODY SMALLINT NOT NULL,
	SHOWVALUES VARCHAR(30) DEFAULT NULL,
	SUBSCRIPTIONTYPE VARCHAR(10) NOT NULL,
	SUBSCRIPTIONDEPTH SMALLINT NOT NULL,
	KEYWORD VARCHAR(200) DEFAULT NULL,
	PRIMARY KEY (SERVICEID, NODEID, ID)
);
/
CREATE TABLE OFPUBSUBDEFAULTCONF (
	SERVICEID VARCHAR(100) NOT NULL,
	LEAF SMALLINT NOT NULL,
	DELIVERPAYLOADS SMALLINT NOT NULL,
	MAXPAYLOADSIZE INT NOT NULL,
	PERSISTITEMS SMALLINT NOT NULL,
	MAXITEMS INT NOT NULL,
	NOTIFYCONFIGCHANGES SMALLINT NOT NULL,
	NOTIFYDELETE SMALLINT NOT NULL,
	NOTIFYRETRACT SMALLINT NOT NULL,
	PRESENCEBASED SMALLINT NOT NULL,
	SENDITEMSUBSCRIBE SMALLINT NOT NULL,
	PUBLISHERMODEL VARCHAR(15) NOT NULL,
	SUBSCRIPTIONENABLED SMALLINT NOT NULL,
	ACCESSMODEL VARCHAR(10) NOT NULL,
	LANGUAGE VARCHAR(255) DEFAULT NULL,
	REPLYPOLICY VARCHAR(15) DEFAULT NULL,
	ASSOCIATIONPOLICY VARCHAR(15) NOT NULL,
	MAXLEAFNODES INT NOT NULL,
	PRIMARY KEY (SERVICEID, LEAF)
);
/
INSERT INTO ofID (idType, id) VALUES (18, 1);
/
INSERT INTO ofID (idType, id) VALUES (19, 1);
/
INSERT INTO ofID (idType, id) VALUES (23, 1);
/
INSERT INTO ofID (idType, id) VALUES (26, 2);
/
CREATE TABLE SOCIAL_IMMSGREAD (
	ID SERIAL NOT NULL,
	MSGID VARCHAR(600) DEFAULT NULL,
	RECEIVERID VARCHAR(600) DEFAULT NULL,
	STATUS INT DEFAULT NULL,
	SENDTIME CHAR(100) DEFAULT NULL,
	USERID VARCHAR(600) DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
CREATE INDEX social_IMMsgRead_index ON social_IMMsgRead(msgid) ;
/
CREATE INDEX social_IMMR_userid_idx ON social_IMMsgRead(userid) ;
/
CREATE INDEX social_IMMR_sendtime_idx ON social_IMMsgRead(sendtime);
/
CREATE TABLE SOCIAL_IMRECENTCONVER (
	ID SERIAL NOT NULL,
	USERID VARCHAR(600) DEFAULT NULL,
	TARGETID VARCHAR(600) DEFAULT NULL,
	ISDEL SMALLINT DEFAULT NULL,
	ISTOP SMALLINT DEFAULT NULL,
	UNREADCOUNT INT DEFAULT NULL,
	UPDATETIME BIGINT DEFAULT NULL,
	SENDID VARCHAR(600) DEFAULT NULL,
	TARGETTYPE VARCHAR(100) DEFAULT NULL,
	MSGID VARCHAR(600) DEFAULT NULL,
	MSGCONTENT VARCHAR(4000) DEFAULT NULL,
	TARGETNAME VARCHAR(600) DEFAULT NULL,
	LASTTIME VARCHAR(600) DEFAULT NULL,
	CONTENT VARCHAR(4000) DEFAULT NULL,
	OBJECTNAME VARCHAR(400) DEFAULT NULL,
	SHARETYPENAME VARCHAR(400) DEFAULT NULL,
	SHARETYPE VARCHAR(600) DEFAULT NULL,
	ISAT VARCHAR(24) DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
CREATE TABLE HISTORYMSG (
	ID SERIAL NOT NULL,
	FROMUSERID VARCHAR(600) DEFAULT NULL,
	TARGETID VARCHAR(600) DEFAULT NULL,
	TARGETTYPE VARCHAR(600) DEFAULT NULL,
	GROUPID VARCHAR(600) DEFAULT NULL,
	CLASSNAME VARCHAR(600) DEFAULT NULL,
	MSGCONTENTBAK TEXT,
	EXTRA TEXT,
	TYPE VARCHAR(600) DEFAULT NULL,
	IMAGEURI VARCHAR(600) DEFAULT NULL,
	DATETIME VARCHAR(600) DEFAULT NULL,
	MSGID VARCHAR(600) DEFAULT NULL,
	MSGCONTENT TEXT,
	FULLAMOUNT TEXT,
	UPDATETIME VARCHAR(600) DEFAULT NULL,
	ISDEL SMALLINT DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
CREATE INDEX index_HistoryMsgfromUserId ON HistoryMsg(fromUserId);
/
CREATE INDEX index_HistoryMsgtargetId ON HistoryMsg(targetId);
/
CREATE INDEX index_HistoryMsgGroupId ON HistoryMsg(GroupId);
/
CREATE INDEX index_HistoryMsgdateTime ON HistoryMsg(dateTime);
/
CREATE INDEX index_HistoryMsgmsgid ON HistoryMsg(msgid);
/
CREATE TABLE MOBILE_DING (
	ID SERIAL NOT NULL,
	SENDID VARCHAR(600) NOT NULL,
	CONTENT TEXT DEFAULT NULL,
	SCOPEID VARCHAR(600) DEFAULT NULL,
	MESSAGEID VARCHAR(600) DEFAULT NULL,
	UDID VARCHAR(600) DEFAULT NULL,
	OPERATE_DATE CHAR(120) NOT NULL,
	DING_MODULE SMALLINT DEFAULT NULL,
	HAD_SEND SMALLINT DEFAULT NULL,
	ISDEL SMALLINT NOT NULL DEFAULT '0',
	DELETE_DATE CHAR(300) DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
CREATE TABLE MOBILE_DINGRECIVER (
	ID SERIAL NOT NULL,
	DINGID INT NOT NULL,
	USERID VARCHAR(600) NOT NULL,
	CONFIRM CHAR(120) NOT NULL,
	ISDEL SMALLINT NOT NULL DEFAULT '0',
	PRIMARY KEY (ID)
);
/
CREATE TABLE MOBILE_DINGREPLY (
	ID SERIAL NOT NULL,
	DINGID INT NOT NULL,
	USERID VARCHAR(600) NOT NULL,
	CONTENT TEXT DEFAULT NULL,
	OPERATE_DATE CHAR(120) NOT NULL,
	ISDEL SMALLINT NOT NULL DEFAULT '0',
	PRIMARY KEY (ID)
);
/
CREATE TABLE MOBILEPROPERTY (
	NAME VARCHAR(600) NOT NULL,
	PROPVALUE VARCHAR(600) DEFAULT NULL,
	PRIMARY KEY (NAME)
);
/
CREATE TABLE SOCIAL_HISTORYMSGRIGHT (
	ID SERIAL NOT NULL,
	USERID VARCHAR(600) DEFAULT NULL,
	MSGID VARCHAR(600) DEFAULT NULL,
	ISDEL SMALLINT DEFAULT NULL,
	DATETIME VARCHAR(600) DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
CREATE INDEX historyMsgRight_userid_index ON Social_historyMsgRight(userId);
/
CREATE INDEX historyMsgRight_msgid_index ON Social_historyMsgRight(msgId);
/
CREATE TABLE SOCIAL_IMCONVERSATION (
	ID SERIAL NOT NULL,
	USERID VARCHAR(600) DEFAULT NULL,
	TARGETID VARCHAR(600) DEFAULT NULL,
	TARGETTYPE VARCHAR(120) DEFAULT NULL,
	TARGETPORTRAIT VARCHAR(600) DEFAULT NULL,
	TARGETNAME VARCHAR(600) DEFAULT NULL,
	UNREADCNT INT DEFAULT NULL,
	ISTOP CHAR(6) DEFAULT NULL,
	LASTTIME VARCHAR(600) DEFAULT NULL,
	SENDERID VARCHAR(600) DEFAULT NULL,
	ISOPENFIRE INT DEFAULT NULL,
	MSGCONTENT TEXT DEFAULT NULL,
	MSGID VARCHAR(600) DEFAULT NULL,
	SENDID VARCHAR(600) DEFAULT NULL,
	PRIMARY KEY (ID)
);
/
CREATE TABLE MOBILE_RONGGROUPNOTICE (
	ID SERIAL NOT NULL,
	TARGETID VARCHAR(600) DEFAULT NULL,
	SENDID VARCHAR(600) DEFAULT NULL,
	CONTENT TEXT DEFAULT NULL,
	OPERATE_DATE CHAR(300) NOT NULL,
	PRIMARY KEY (ID)
);
/
-- Entry for admin user
-- 开启定期修改admin密码
insert into ofProperty(name,propValue) values ('change-password-periodically','true');
/
--密码有效期为 90天
insert into ofProperty(name,propValue) values ('require-change-password-period-seconds','7776000');

/
-- 密码过期后，必须修改密码才可以进入
insert into ofProperty(name,propValue) values ('must-change-password','true');
/
-- 初始密码不允许登录
insert into ofProperty(name,propValue) values ('defaultPassword-login','false');
/
-- 需要生成admin用户，并设置默认密码，默认密码生成到默认文件中
insert into ofProperty(name,propValue) values ('need-set-admin-password','true');
/
INSERT INTO ofMucService (serviceID, subdomain, isHidden) VALUES (1, 'conference', 0);
/
INSERT INTO ofVersion (name, version) VALUES ('openfire', 26);
/
