create index em_shmr_group  on Social_historyMsgRight(userId,msgId);
/
CREATE TABLE OFROUTEMESSAGE (
  messageID    int  not null auto_increment,
  jid          VARCHAR(128)      NOT NULL,
  creationDate DECIMAL(38) NOT NULL,
  message      TEXT     NOT NULL,
  fromJid      VARCHAR(128),
  primary key(messageID)
);
/
CREATE INDEX index_ormjid ON OFROUTEMESSAGE (jid);
/
CREATE INDEX index_ormcreationDate ON OFROUTEMESSAGE (creationDate);
/
CREATE TABLE OFHASROUTEDMESSAGE (
  messageID	   VARCHAR(128)  NOT NULL ,
  jid          VARCHAR(128)      NOT NULL,
  message      TEXT      NOT NULL,
  creationDate DECIMAL(38)
);
/
CREATE INDEX index_ohrmmessageID ON OFHASROUTEDMESSAGE (messageID);
/
CREATE INDEX index_ohrmjid ON OFHASROUTEDMESSAGE (jid);
/
CREATE INDEX index_OFHASRMcreationDate ON OFHASROUTEDMESSAGE(creationDate);
/
CREATE TABLE OFPUSHDEVICE(
 pushid        int NOT NULL auto_increment,
 userid        VARCHAR(32)         NOT NULL,
 devicetype    VARCHAR(64)         NOT NULL,
 token	       VARCHAR(500)         NOT NULL,
 pushStatus    VARCHAR(128),
 language      VARCHAR(12),
 pushKitDeviceToken VARCHAR(128),
 mobileVersion VARCHAR(2),
 packagename varchar(100),
 primary key(pushid)
);
/
CREATE TABLE OFPUSHSETTING(
  targetId   VARCHAR(100)         NOT NULL,
  targetType   VARCHAR(100)         NOT NULL,
  username    VARCHAR(100)         NOT NULL,
  propvalue	 VARCHAR(32)            NOT NULL
);
/
create table HistoryMsgRecently(
	id int NOT NULL auto_increment,
	fromUserId varchar(100),
	targetId varchar(100),
	targetType varchar(100),
	GroupId varchar(100),
	classname varchar(100),
	msgContent TEXT,
	extra TEXT,
	type varchar(100),
	imageUri varchar(100),
	dateTime varchar(100),
	msgid  varchar(100),
	fullAmount TEXT,
	primary key (id)
);
/
CREATE INDEX index_hmrUserId ON HistoryMsgRecently (fromUserId);
/
CREATE INDEX index_hmrtargetId ON HistoryMsgRecently (targetId);
/
CREATE INDEX index_hmrGroupId ON HistoryMsgRecently (GroupId);
/
CREATE INDEX index_hmrdateTime ON HistoryMsgRecently (dateTime);
/
CREATE INDEX index_hmrmsgid ON HistoryMsgRecently (msgid);
/
insert into ofProperty(name,propValue) values ('xmpp.client.processing.threads','1000');
/
insert into ofProperty(name,propValue) values ('httpbind.client.processing.threads','1000');
/
insert into ofProperty(name,propValue) values ('xmpp.client.roster.active','false');
/
insert into ofProperty(name,propValue) values ('xmpp.pep.enabled','false');
/
ALTER TABLE social_IMConversation ADD COLUMN msgid VARCHAR(128);
/
CREATE TABLE OFFUNSETTING(
 userid        VARCHAR(100)         NOT NULL,
 funname    VARCHAR(64)         NOT NULL,
 funvalue	       VARCHAR(200)         NOT NULL
);
/
CREATE INDEX index_funsetUserId ON OFFUNSETTING (userid);
/
CREATE INDEX index_funsetUsername ON OFFUNSETTING (funname);
/
CREATE TABLE OFTEMPORARYRELATIONSHIP(
 username        VARCHAR(64)         NOT NULL,
 followUsername    VARCHAR(64)         NOT NULL,
 primary key(username,followUsername)
);
/
ALTER TABLE social_IMRecentConver ADD COLUMN isdel TINYINT(1);
/
ALTER TABLE social_IMRecentConver ADD COLUMN istop TINYINT(1);
/
ALTER TABLE Social_historyMsgRight ADD COLUMN isdel TINYINT(1);
/
ALTER TABLE social_IMRecentConver ADD COLUMN unreadcount int;
/
ALTER TABLE social_IMRecentConver ADD COLUMN updatetime  bigint;
/
CREATE INDEX index_im_RecentConver_Targetid ON social_IMRecentConver (targetid);
/
CREATE INDEX index_im_RecentConver_Userid ON social_IMRecentConver (userid);
/
ALTER TABLE mobile_ding ADD COLUMN ding_module   TINYINT(1) ;
/
ALTER TABLE mobile_ding ADD COLUMN had_send   TINYINT(1) ;
/
ALTER TABLE historyMsg ADD COLUMN updatetime varchar(100);
/
create table ofpushinfo(
	id int NOT NULL auto_increment,
	devicetype    varchar(64) NOT NULL,
	packagename   varchar(100) NOT NULL,
	appKey varchar(128),
    secret varchar(128),
    appName varchar(128),
    appId varchar(64),
    primary key (id)
);
/
create table ofunitemsginfo(
	id int NOT NULL auto_increment,
	uniteMsgId varchar(128),
	msgIds TEXT,
	primary key (id)
);
/
ALTER TABLE historyMsg ADD COLUMN isdel TINYINT(1);
/
ALTER TABLE social_IMConversation ADD COLUMN sendid VARCHAR(128);
/
create table ofMsgCollect(
	id int NOT NULL auto_increment PRIMARY KEY,
	username varchar(128),
	msgId varchar(128),
	msgContent text,
	className varchar(100),
	createTime varchar(100),
	collectSource varchar(512)
);
/
CREATE INDEX index_ofMsgCollectusername ON ofMsgCollect(username);
/
CREATE INDEX index_ofMsgCollectclassName ON ofMsgCollect(className);
/
CREATE INDEX index_ofMsgCollectmsgId ON ofMsgCollect(msgId);
/
ALTER TABLE social_IMRecentConver ADD sendId varchar(128);
/
ALTER TABLE social_IMRecentConver ADD targettype varchar(20);
/
ALTER TABLE social_IMRecentConver ADD msgId varchar(128);
/
ALTER TABLE social_IMRecentConver ADD msgcontent varchar(4000);
/
ALTER TABLE social_IMRecentConver ADD targetname varchar(100);
/
ALTER TABLE social_IMRecentConver ADD lasttime varchar(100);
/
create index index_mobile_dingreciver_dingid on mobile_dingReciver(dingid);
/
create index index_mobile_dingreciver_userid on mobile_dingReciver(userid);
/
create index index_mobile_ding_id on mobile_ding(id);
/
create table ofDeleteHistoryMsg(
	id int NOT NULL auto_increment PRIMARY KEY,
	operator VARCHAR(128),
	operatorTime VARCHAR(36),
	msgid VARCHAR(128),
	msgcontent text,
	fromUserId VARCHAR(50),
	targetType VARCHAR(20),
	operatorIP VARCHAR(36),
	opeartorDevice VARCHAR(30)
);
/
ALTER TABLE mobile_ding ADD COLUMN isdel TINYINT(1) not null default 0;
/
ALTER TABLE mobile_ding ADD COLUMN delete_date char(50);
/
ALTER TABLE mobile_dingreply ADD COLUMN isdel TINYINT(1) not null default 0;
/
ALTER TABLE mobile_dingreciver ADD COLUMN isdel TINYINT(1) not null default 0;
/
ALTER TABLE ofgroupuser ADD lasttime varchar(100);
/
ALTER TABLE social_historymsgright ADD datetime varchar(100);
/
ALTER TABLE social_IMRecentConver ADD content varchar(1000);
/
ALTER TABLE social_IMRecentConver ADD objectname varchar(128);
/
ALTER TABLE social_IMRecentConver ADD sharetypename varchar(128);
/
ALTER TABLE social_IMRecentConver ADD sharetype varchar(128);
/
ALTER TABLE social_IMRecentConver ADD isAt varchar(4);
/
ALTER TABLE ofuser ADD isTurnover varchar(4);
/
ALTER TABLE ofgroupuser ADD isdel varchar(4);
/
CREATE TABLE OFMSGSTATISTICDAY (
  id	   int  not null auto_increment,
  userId          VARCHAR(128)      NOT NULL,
  day VARCHAR(32),
  month      VARCHAR(32),
  year      VARCHAR(32),
  sendCount int,
  receiveCount int,
  primary key(id)
);
/
create index msgstaday_userId on OFMSGSTATISTICDAY(userId);
/
create index msgstaday_day on OFMSGSTATISTICDAY(day);
/
create index msgstaday_month on OFMSGSTATISTICDAY(month);
/
create index msgstaday_year on OFMSGSTATISTICDAY(year);
/
CREATE TABLE OFMSGSTATISTICMONTH (
  id	   int  not null auto_increment,
  userId          VARCHAR(128)      NOT NULL,
  month      VARCHAR(32),
  year      VARCHAR(32),
  sendCount int,
  receiveCount int,
  primary key(id)
);
/
create index msgstamonth_userId on OFMSGSTATISTICMONTH(userId);
/
create index msgstamonth_month on OFMSGSTATISTICMONTH(month);
/
create index msgstamonth_year on OFMSGSTATISTICMONTH(year);
/
CREATE TABLE OFMSGSTATISTICYEAR (
  id	   int  not null auto_increment,
  userId          VARCHAR(128)      NOT NULL,
  year      VARCHAR(32),
  sendCount int,
  receiveCount int,
  primary key(id)
);
/
create index msgstayear_userId on OFMSGSTATISTICYEAR(userId);
/
create index msgstayear_year on OFMSGSTATISTICYEAR(year);
/
update social_IMRecentConver set targetType = '1' where id in(select a.id  from social_IMRecentConver a ,social_IMConversation b where a.targetid = b.targetId and (a.targettype is null or a.targettype = '') and b.targettype = '1');
/
CREATE TABLE OFMSGSTATISTICCHATDAY (
  id	   int  not null auto_increment,
  userId          VARCHAR(128)      NOT NULL,
  targetId VARCHAR(256),
  targetType VARCHAR(4),
  day VARCHAR(32),
  month      VARCHAR(32),
  year      VARCHAR(32),
  primary key(id)
);
/
create index msgstachatday_userId on OFMSGSTATISTICCHATDAY(userId);
/
create index msgstachatday_day on OFMSGSTATISTICCHATDAY(day);
/
create index msgstachatday_month on OFMSGSTATISTICCHATDAY(month);
/
create index msgstachatday_year on OFMSGSTATISTICCHATDAY(year);
/
CREATE TABLE OFMSGSTATISTICCHATMONTH (
  id	   int  not null auto_increment,
  userId          VARCHAR(128)      NOT NULL,
  month      VARCHAR(32),
  year      VARCHAR(32),
  chatCount int,
  groupChatCount int,
  primary key(id)
);
/
create index msgstamonthchat_userId on OFMSGSTATISTICCHATMONTH(userId);
/
create index msgstamonthchat_month on OFMSGSTATISTICCHATMONTH(month);
/
create index msgstamonthchat_year on OFMSGSTATISTICCHATMONTH(year);
/
CREATE TABLE OFMSGSTATISTICCHATYEAR (
  id	   int  not null auto_increment,
  userId          VARCHAR(128)      NOT NULL,
  year      VARCHAR(32),
  chatCount int,
  groupChatCount int,
  primary key(id)
);
/
create index msgstachatyear_userId on OFMSGSTATISTICCHATYEAR(userId);
/
create index msgstachatyear_year on OFMSGSTATISTICCHATYEAR(year);
/
CREATE TABLE ofmsgpushsetting (
  id	   int  not null auto_increment,
  userId          VARCHAR(128)      NOT NULL,
  pushStatus VARCHAR(4),
  startTime VARCHAR(32),
  endTime      VARCHAR(32),
  primary key(id)
);
/
create index ofmsgpushsetting_userId on ofmsgpushsetting(userId);
/
CREATE TABLE OFCONVERSTATISDAY (
  id	   int  not null auto_increment,
  userId          VARCHAR(128)      NOT NULL,
  targetId VARCHAR(256),
  targetType VARCHAR(4),
  day VARCHAR(32),
  month      VARCHAR(32),
  year      VARCHAR(32),
  sendCount int,
  receiveCount int,
  primary key(id)
);
/
create index converstatis_userId on OFCONVERSTATISDAY(userId);
/
create index converstatis_targetType on OFCONVERSTATISDAY(targetType);
/
create index converstatis_day on OFCONVERSTATISDAY(day);
/
create index converstatis_month on OFCONVERSTATISDAY(month);
/
create index converstatis_year on OFCONVERSTATISDAY(year);
/
CREATE TABLE OFCONVERSTATISMONTH (
  id	   int  not null auto_increment,
  userId          VARCHAR(128)      NOT NULL,
  targetId VARCHAR(256),
  targetType VARCHAR(4),
  month      VARCHAR(32),
  year      VARCHAR(32),
  sendCount int,
  receiveCount int,
  primary key(id)
);
/
create index converstatism_userId on OFCONVERSTATISMONTH(userId);
/
create index converstatism_targetType on OFCONVERSTATISMONTH(targetType);
/
create index converstatism_month on OFCONVERSTATISMONTH(month);
/
create index converstatism_year on OFCONVERSTATISMONTH(year);
/
CREATE TABLE OFCONVERSTATISYEAR (
   id	   int  not null auto_increment,
  userId          VARCHAR(128)      NOT NULL,
  targetId VARCHAR(256),
  targetType VARCHAR(4),
  year      VARCHAR(32),
  sendCount int,
  receiveCount int,
  primary key(id)
);
/
create index converstatisy_userId on OFCONVERSTATISYEAR(userId);
/
create index conversatisy_targetType on OFCONVERSTATISYEAR(targetType);
/
create index converstatisy_year on OFCONVERSTATISYEAR(year);
/
CREATE TABLE Social_historyMsgRecentlyRight (
	id int NOT NULL auto_increment PRIMARY KEY ,
	userId varchar(100) NULL ,
	msgId varchar(100) NULL,
	isdel int,
	datetime varchar(100),
	groupId  varchar(100)
);
/
CREATE INDEX hmrr_userid_index ON Social_historyMsgRecentlyRight(userId);
/
CREATE INDEX hmrr_msgid_index ON Social_historyMsgRecentlyRight(msgId); 
/
CREATE INDEX hmrr_datetime_idx ON Social_historyMsgRecentlyRight(datetime);
/
CREATE INDEX hmrr_groupId_idx ON Social_historyMsgRecentlyRight(groupId);
/
CREATE INDEX em_shhmr_group  ON Social_historyMsgRecentlyRight(userId,msgId);
/
CREATE table ofshareMessageNew(
	id int NOT NULL auto_increment PRIMARY KEY ,
	userId VARCHAR(128),
	shareUserId VARCHAR(128),
	msgId  VARCHAR(128),
	groupId VARCHAR(128),
	shareType VARCHAR(128),
	shareId VARCHAR(128),
	shareTime VARCHAR(24),
	targetId  VARCHAR(128),
	targetType VARCHAR(2),
	shareTimes VARCHAR(10)
);
/
create index osm_shareType on ofshareMessageNew(targetId);
/
create index osm_shareId on ofshareMessageNew(shareId);
/
CREATE table historyMsgRecentlytemp(
	groupId VARCHAR(128),
	maxDatetime VARCHAR(128),
	minDatetime  VARCHAR(128)
);
/
create index hmrt_groupId on historyMsgRecentlytemp(groupId);
/
create index hmrt_maxDatetime on historyMsgRecentlytemp(maxDatetime);
/
create table HistoryMsgSubtableData(
	id int NOT NULL PRIMARY Key auto_increment
	tableName varchar(200) not null,
	startDataTime varchar(128),
	endDataTime varchar(128),
	currentInsert int,
	maxId bigint
);
/
create table msg_indexupdatelog(
	id int NOT NULL IDENTITY(1,1) primary key,
	indextype VARCHAR(4),
	data VARCHAR(128),
	tableName VARCHAR(128),
	dateTime VARCHAR(128)
);
/
create table ofpushlog(
	id int NOT NULL auto_increment PRIMARY KEY,
	username              NVARCHAR(64)    NOT NULL,
  	entryStamp            BIGINT          NOT NULL,
  	summary               NVARCHAR(255)   NOT NULL,
  	node                  NVARCHAR(255)   NOT NULL,
  	details               TEXT
);
/
create index idx_mcl_nm on ofMsgCollect(username);
/
create index idx_mcl_cm on ofMsgCollect(className);
/
create index idx_mcl_ct on ofMsgCollect(createTime); 
/
create table ofpushinfoNew(
	id int NOT NULL auto_increment primary key,
	packagename   varchar(100) NOT NULL,
	appName varchar(128)
);
/
ALTER TABLE ofpushdevice ADD userType NVARCHAR(100);
/
create table ofuserMsgSetting(
	id int NOT NULL auto_increment primary key ,
	userid   varchar(100) NOT NULL,
	targetid varchar(128),
	propValue varchar(12)
);
/
create index idx_oums_ud on ofuserMsgSetting(userid);
/
INSERT INTO ofVersion (name, version) VALUES ('MultiRouterPlugin', 46);
/