create index em_shmr_group  on Social_historyMsgRight(userId,msgId);
/
CREATE TABLE OFROUTEMESSAGE (
  messageID    int  not null,
  jid          VARCHAR(128)      NOT NULL,
  creationDate NUMBER(38,0) NOT NULL,
  message      clob            NOT NULL,
  fromJid      VARCHAR(128)
);
/
CREATE INDEX index_ormjid ON OFROUTEMESSAGE (jid);
/
CREATE INDEX index_ormcreationDate ON OFROUTEMESSAGE (creationDate);
/
create sequence OFROUTEMESSAGE_id
start with 1
increment by 1
nomaxvalue
nocycle;
/
CREATE TABLE OFHASROUTEDMESSAGE (
  messageID	   VARCHAR(128)  NOT NULL ,
  jid          VARCHAR(128)      NOT NULL,
  message      clob            NOT NULL,
  creationDate NUMBER(38,0)
);
/
CREATE INDEX index_ohrmmessageID ON OFHASROUTEDMESSAGE (messageID);
/
CREATE INDEX index_ohrmjid ON OFHASROUTEDMESSAGE (jid);
/
CREATE INDEX index_OFHASRMcreationDate ON OFHASROUTEDMESSAGE(creationDate);
/
CREATE TABLE OFPUSHDEVICE(
 pushid        int NOT NULL,
 userid        VARCHAR(32)         NOT NULL,
 devicetype    VARCHAR(64)         NOT NULL,
 token	       VARCHAR(500)         NOT NULL,
 pushStatus    VARCHAR(128),
 language      VARCHAR(12),
 pushKitDeviceToken VARCHAR(128),
 mobileVersion VARCHAR(2),
 packagename varchar(100)
);
/
create sequence OFPUSHDEVICE_id
start with 1
increment by 1
nomaxvalue
nocycle;
/
CREATE TABLE OFPUSHSETTING(
  targetId   VARCHAR(100)         NOT NULL,
  targetType   VARCHAR(100)         NOT NULL,
  username    VARCHAR(100)         NOT NULL,
  propvalue	 clob            NOT NULL
);
/
create table HistoryMsgRecently(
	id int,
	fromUserId varchar(100),
	targetId varchar(100),
	targetType varchar(100),
	GroupId varchar(100),
	classname varchar(100),
	msgContent clob,
	extra clob,
	type varchar(100),
	imageUri varchar(100),
	"DATETIME" varchar(100),
	msgid  varchar(100),
	fullAmount clob
);
/
CREATE INDEX index_hmrUserId ON HistoryMsgRecently (fromUserId);
/
CREATE INDEX index_hmrtargetId ON HistoryMsgRecently (targetId);
/
CREATE INDEX index_hmrGroupId ON HistoryMsgRecently (GroupId);
/
CREATE INDEX index_hmrdateTime ON HistoryMsgRecently ("DATETIME");
/
CREATE INDEX index_hmrmsgid ON HistoryMsgRecently (msgid);
/
create sequence HistoryMsgRecently_id
start with 1
increment by 1
nomaxvalue
nocycle;
/
insert into ofProperty(name,propValue) values ('xmpp.client.processing.threads','1000');
/
insert into ofProperty(name,propValue) values ('httpbind.client.processing.threads','1000');
/
insert into ofProperty(name,propValue) values ('xmpp.client.roster.active','false');
/
insert into ofProperty(name,propValue) values ('xmpp.pep.enabled','false');
/
ALTER TABLE social_IMConversation ADD msgid VARCHAR(128);
/
CREATE TABLE OFFUNSETTING(
 userid        VARCHAR(100)         NOT NULL,
 funname    VARCHAR(64)         NOT NULL,
 funvalue	       VARCHAR(200)         NOT NULL
);
/
CREATE INDEX index_funsetUserId ON OFFUNSETTING (userid);
/
CREATE INDEX index_funsetUsername ON OFFUNSETTING (funname);
/
CREATE TABLE OFTEMPORARYRELATIONSHIP(
 username        VARCHAR(64)         NOT NULL,
 followUsername    VARCHAR(64)         NOT NULL
);
/
alter table OFTEMPORARYRELATIONSHIP add primary key (username,followUsername);
/
ALTER TABLE social_IMRecentConver ADD isdel INTEGER;
/
ALTER TABLE social_IMRecentConver ADD istop INTEGER;
/
ALTER TABLE Social_historyMsgRight ADD isdel INTEGER;
/
insert into Social_historyMsgRight(userid,msgId) 
SELECT targetid userid ,msgid from  historymsg where targettype != 2
UNION 
SELECT fromuserid userid ,msgid from historymsg where targettype != 2
minus    
select userid,msgid from Social_historyMsgRight ;
/
ALTER TABLE social_IMRecentConver ADD unreadcount int;
/
ALTER TABLE social_IMRecentConver ADD updatetime NUMBER(38,0);
/
CREATE INDEX index_im_RecentConver_Targetid ON social_IMRecentConver (targetid);
/
CREATE INDEX index_im_RecentConver_Userid ON social_IMRecentConver (userid);
/
ALTER TABLE mobile_ding ADD  ding_module   INTEGER;
/
ALTER TABLE mobile_ding ADD  had_send  INTEGER;
/
ALTER TABLE historyMsg ADD updatetime varchar(100);
/
create table ofpushinfo(
	id int NOT NULL,
	devicetype    varchar(64) NOT NULL,
	packagename   varchar(100) NOT NULL,
	appKey varchar(128),
    secret varchar(128),
    appName varchar(128),
    appId varchar(64)
);
/
create sequence ofpushinfo_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger ofpushinfo_seq_tri
before insert on ofpushinfo
for each row
begin
select ofpushinfo_seq.nextval into :new.id from dual;
end;;
/
create table ofunitemsginfo(
	id int NOT NULL primary key,
	uniteMsgId varchar(128),
	msgIds clob
);
/
create sequence ofunitemsginfo_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger ofunitemsginfo_seq_tri
before insert on ofunitemsginfo
for each row
begin
select ofunitemsginfo_seq.nextval into :new.id from dual;
end;;
/
ALTER TABLE historyMsg ADD isdel INTEGER;
/
ALTER TABLE social_IMConversation ADD sendid VARCHAR(128);
/
create table ofMsgCollect(
	id int NOT NULL primary key,
	username varchar(128),
	msgId varchar(128),
	msgContent clob,
	className varchar(100),
	createTime varchar(100),
	collectSource varchar(512)
);
/
CREATE INDEX index_ofMsgCollectusername ON ofMsgCollect(username);
/
CREATE INDEX index_ofMsgCollectclassName ON ofMsgCollect(className);
/
CREATE INDEX index_ofMsgCollectmsgId ON ofMsgCollect(msgId);
/
create sequence ofMsgCollect_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger ofMsgCollect_seq_tri
before insert on ofMsgCollect
for each row
begin
select ofMsgCollect_seq.nextval into :new.id from dual;
end;;
/
ALTER TABLE social_IMRecentConver ADD sendId varchar(128);
/
ALTER TABLE social_IMRecentConver ADD targettype varchar(20);
/
ALTER TABLE social_IMRecentConver ADD msgId varchar(128);
/
ALTER TABLE social_IMRecentConver ADD msgcontent varchar(4000);
/
ALTER TABLE social_IMRecentConver ADD targetname varchar(100);
/
ALTER TABLE social_IMRecentConver ADD lasttime varchar(100);
/
create index idx_mbdingre_did on mobile_dingReciver(dingid);
/
create index idx_mbdingre_uid on mobile_dingReciver(userid);
/
create index idx_mbdingre_id on mobile_ding(id);
/
create table ofDeleteHistoryMsg(
	id int NOT NULL primary key,
	operator VARCHAR(128),
	operatorTime VARCHAR(36),
	msgid VARCHAR(128),
	msgcontent clob,
	fromUserId VARCHAR(50),
	targetType VARCHAR(20),
	operatorIP VARCHAR(36),
	opeartorDevice VARCHAR(30)
);
/
create sequence ofDeleteHistoryMsg_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger ofDeleteHistoryMsg_seq_tri
before insert on ofDeleteHistoryMsg
for each row
begin
select ofDeleteHistoryMsg_seq.nextval into :new.id from dual;
end;;
/
ALTER TABLE mobile_ding ADD isdel INTEGER default 0 not null;
/
ALTER TABLE mobile_ding ADD delete_date VARCHAR2(1000);
/
ALTER TABLE mobile_dingreply ADD isdel INTEGER default 0 not null ;
/
ALTER TABLE mobile_dingreciver ADD isdel INTEGER default 0 not null;
/
ALTER TABLE ofgroupuser ADD lasttime varchar(100);
/
ALTER TABLE social_historymsgright ADD "DATETIME" varchar(100);
/
ALTER TABLE social_IMRecentConver ADD content varchar(4000);
/
ALTER TABLE social_IMRecentConver ADD objectname varchar(128);
/
ALTER TABLE social_IMRecentConver ADD sharetypename varchar(4000);
/
ALTER TABLE social_IMRecentConver ADD sharetype varchar(128);
/
ALTER TABLE social_IMRecentConver ADD isAt varchar(4);
/
ALTER TABLE ofuser ADD isTurnover varchar(4);
/
ALTER TABLE ofgroupuser ADD isdel varchar(4);
/
CREATE TABLE OFMSGSTATISTICDAY (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  day VARCHAR(32),
  month      VARCHAR(32),
  year      VARCHAR(32),
  sendCount int,
  receiveCount int
);
/
create sequence OFMSGSTATISTICDAY_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger OFMSGSTATISTICDAY_seq_tri
before insert on OFMSGSTATISTICDAY
for each row
begin
select OFMSGSTATISTICDAY_seq.nextval into :new.id from dual;
end;;
/
create index msgstaday_userId on OFMSGSTATISTICDAY(userId);
/
create index msgstaday_day on OFMSGSTATISTICDAY(day);
/
create index msgstaday_month on OFMSGSTATISTICDAY(month);
/
create index msgstaday_year on OFMSGSTATISTICDAY(year);
/
CREATE TABLE OFMSGSTATISTICMONTH (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  month      VARCHAR(32),
  year      VARCHAR(32),
  sendCount int,
  receiveCount int
);
/
create sequence OFMSGSTATISTICMONTH_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger OFMSGSTATISTICMONTH_seq_tri
before insert on OFMSGSTATISTICMONTH
for each row
begin
select OFMSGSTATISTICMONTH_seq.nextval into :new.id from dual;
end;;
/
create index msgstamonth_userId on OFMSGSTATISTICMONTH(userId);
/
create index msgstamonth_month on OFMSGSTATISTICMONTH(month);
/
create index msgstamonth_year on OFMSGSTATISTICMONTH(year);
/
CREATE TABLE OFMSGSTATISTICYEAR (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  year      VARCHAR(32),
  sendCount int,
  receiveCount int
);
/
create sequence OFMSGSTATISTICYEAR_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger OFMSGSTATISTICYEAR_seq_tri
before insert on OFMSGSTATISTICYEAR
for each row
begin
select OFMSGSTATISTICYEAR_seq.nextval into :new.id from dual;
end;;
/
create index msgstayear_userId on OFMSGSTATISTICYEAR(userId);
/
create index msgstayear_year on OFMSGSTATISTICYEAR(year);
/
update social_IMRecentConver set targetType = '1' where id in(select a.id  from social_IMRecentConver a ,social_IMConversation b where a.targetid = b.targetId and (a.targettype is null or a.targettype = '') and b.targettype = '1');
/
CREATE TABLE OFMSGSTATISTICCHATDAY (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  targetId VARCHAR(256),
  targetType VARCHAR(4),
  day VARCHAR(32),
  month      VARCHAR(32),
  year      VARCHAR(32)
);
/
create sequence OFMSGSTATISTICCHATDAY_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger OFMSGSTATISTICCHATDAY_seq_tri
before insert on OFMSGSTATISTICCHATDAY
for each row
begin
select OFMSGSTATISTICCHATDAY_seq.nextval into :new.id from dual;
end;;
/
create index msgstachatday_userId on OFMSGSTATISTICCHATDAY(userId);
/
create index msgstachatday_targetType on OFMSGSTATISTICCHATDAY(targetType);
/
create index msgstachatday_day on OFMSGSTATISTICCHATDAY(day);
/
create index msgstachatday_month on OFMSGSTATISTICCHATDAY(month);
/
create index msgstachatday_year on OFMSGSTATISTICCHATDAY(year);
/
CREATE TABLE OFMSGSTATISTICCHATMONTH (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  month      VARCHAR(32),
  year      VARCHAR(32),
  chatCount int,
  groupChatCount int
);
/
create sequence OFMSGSTATISTICCHATMONTH_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger OFMSGSTATISTTH_seq_tri
before insert on OFMSGSTATISTICCHATMONTH
for each row
begin
select OFMSGSTATISTICCHATMONTH_seq.nextval into :new.id from dual;
end;;
/
create index msgstachatmonth_userId on OFMSGSTATISTICCHATMONTH(userId);
/
create index msgstachatmonth_month on OFMSGSTATISTICCHATMONTH(month);
/
create index msgstachatmonth_year on OFMSGSTATISTICCHATMONTH(year);
/
CREATE TABLE OFMSGSTATISTICCHATYEAR (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  targetType VARCHAR(4),
  year      VARCHAR(32),
  chatCount int,
  groupChatCount int
);
/
create sequence OFMSGSTATISTICCHATYEAR_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger OFMSGSTATISTICCHATYEAR_seq_tri
before insert on OFMSGSTATISTICCHATYEAR
for each row
begin
select OFMSGSTATISTICCHATYEAR_seq.nextval into :new.id from dual;
end;;
/
create index msgstachatyear_userId on OFMSGSTATISTICCHATYEAR(userId);
/
create index msgstachatyear_year on OFMSGSTATISTICCHATYEAR(year);
/
CREATE TABLE ofmsgpushsetting (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  pushStatus VARCHAR(4),
  startTime VARCHAR(32),
  endTime VARCHAR(32)
);
/
create sequence ofmsgpushsetting_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger ofmsgpushsetting_seq_tri
before insert on ofmsgpushsetting
for each row
begin
select ofmsgpushsetting_seq.nextval into :new.id from dual;
end;;
/
create index ofmsgpushsetting_userId on ofmsgpushsetting(userId);
/
CREATE TABLE OFCONVERSTATISDAY (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  targetId VARCHAR(256),
  targetType VARCHAR(4),
  day VARCHAR(32),
  month      VARCHAR(32),
  year      VARCHAR(32),
  sendCount int,
  receiveCount int
);
/
create sequence OFCONVERSTATISDAY_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger OFCONVERSTATISDAY_seq_tri
before insert on OFCONVERSTATISDAY
for each row
begin
select OFCONVERSTATISDAY_seq.nextval into :new.id from dual;
end;;
/
create index converstatis_userId on OFCONVERSTATISDAY(userId);
/
create index converstatis_targetType on OFCONVERSTATISDAY(targetType);
/
create index converstatis_day on OFCONVERSTATISDAY(day);
/
create index converstatis_month on OFCONVERSTATISDAY(month);
/
create index converstatis_year on OFCONVERSTATISDAY(year);
/
CREATE TABLE OFCONVERSTATISMONTH (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  targetId VARCHAR(256),
  targetType VARCHAR(4),
  month      VARCHAR(32),
  year      VARCHAR(32),
  sendCount int,
  receiveCount int
);
/
create sequence OFCONVERSTATISMONTH_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger OFCONVERSTATISMONTH_seq_tri
before insert on OFCONVERSTATISMONTH
for each row
begin
select OFCONVERSTATISMONTH_seq.nextval into :new.id from dual;
end;;
/
create index converstatism_userId on OFCONVERSTATISMONTH(userId);
/
create index converstatism_targetType on OFCONVERSTATISMONTH(targetType);
/
create index converstatism_month on OFCONVERSTATISMONTH(month);
/
create index converstatism_year on OFCONVERSTATISMONTH(year);
/
CREATE TABLE OFCONVERSTATISYEAR (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  targetId VARCHAR(256),
  targetType VARCHAR(4),
  year      VARCHAR(32),
  sendCount int,
  receiveCount int
);
/
create sequence OFCONVERSTATISYEAR_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger OFCONVERSTATISYEAR_seq_tri
before insert on OFCONVERSTATISYEAR
for each row
begin
select OFCONVERSTATISYEAR_seq.nextval into :new.id from dual;
end;;
/
create index converstatisy_userId on OFCONVERSTATISYEAR(userId);
/
create index conversatisy_targetType on OFCONVERSTATISYEAR(targetType);
/
create index converstatisy_year on OFCONVERSTATISYEAR(year);
/
create table Social_historyMsgRecentlyRight(
	id number(10) primary key,
	userId varchar2(100),
	msgId varchar2(100),
	isdel number(2),
	"DATETIME" varchar(100),
	groupId  varchar(100)
);
/
create sequence SohisMsgrecright_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle;
/
create or replace trigger SohisMsgrecright_seq_tri
before insert on Social_historyMsgRecentlyRight
for each row
begin
select SohisMsgrecright_seq.nextval into :new.id from dual;
end;;
/
CREATE INDEX hmrr_userid_index ON Social_historyMsgRecentlyRight(userId);
/
CREATE INDEX hmrr_msgid_index ON Social_historyMsgRecentlyRight(msgId); 
/
CREATE INDEX hmrr_datetime_idx ON Social_historyMsgRecentlyRight("DATETIME");
/
CREATE INDEX hmrr_groupId_idx ON Social_historyMsgRecentlyRight(groupId);
/
CREATE INDEX em_smr_group  ON Social_historyMsgRecentlyRight(userId,msgId);
/
CREATE table ofshareMessageNew(
	userId VARCHAR(128),
	shareUserId VARCHAR(128),
	msgId  VARCHAR(128),
	groupId VARCHAR(128),
	shareType VARCHAR(128),
	shareId VARCHAR(128),
	shareTime VARCHAR(24),
	targetId  VARCHAR(128),
	targetType VARCHAR(2),
	shareTimes VARCHAR(10)
);
/
create index osm_shareType on ofshareMessageNew(targetId);
/
create index osm_shareId on ofshareMessageNew(shareId);
/
CREATE table historyMsgRecentlytemp(
	groupId VARCHAR(128),
	maxDatetime VARCHAR(128),
	minDatetime  VARCHAR(128)
);
/
create index hmrt_groupId on historyMsgRecentlytemp(groupId);
/
create index hmrt_maxDatetime on historyMsgRecentlytemp(maxDatetime);
/
create table HistoryMsgSubtableData(
	id number(20) primary key,
	tableName varchar2(100),
	startDataTime varchar2(100),
	endDataTime number(2),
	currentInsert varchar(100),
	maxId  number(20)
);
/
create sequence HMSubtableData_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle;
/
create or replace trigger HMStableData_seq_tri
before insert on HistoryMsgSubtableData
for each row
begin
select HMSubtableData_seq.nextval into :new.id from dual;
end;;
/
create table msg_indexupdatelog(
	id number(20) primary key,
	indextype VARCHAR(4),
	data VARCHAR(128),
	tableName VARCHAR(128),
	"DATETIME" VARCHAR(128)
);
/
create sequence msg_indexupdatelog_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle;
/
create or replace trigger msg_indexupdatelog_seq_tri
before insert on msg_indexupdatelog
for each row
begin
select msg_indexupdatelog_seq.nextval into :new.id from dual;
end;;
/
create table ofpushlog(
	id number(20) primary key,
  	username              VARCHAR2(64)    NOT NULL,
 	entryStamp            number(20,2)          NOT NULL,
  	summary               VARCHAR2(255)   NOT NULL,
  	node                  VARCHAR2(255)   NOT NULL,
  	details               VARCHAR2(4000)
);
/
create sequence ofpushlog_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle;
/
create or replace trigger ofpushlog_seqtri
before insert on ofpushlog
for each row
begin
select ofpushlog_seq.nextval into :new.id from dual;
end;;
/
create index idx_mcl_nm on ofMsgCollect(username);
/
create index idx_mcl_cm on ofMsgCollect(className);
/
create index idx_mcl_ct on ofMsgCollect(createTime); 
/
create table ofpushinfoNew(
	id int NOT NULL,
	packagename   varchar(100) NOT NULL,
	appName varchar(128)
);
/
create sequence ofpushinfoNew_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger ofpushinfoNew_seq_tri
before insert on ofpushinfoNew
for each row
begin
select ofpushinfoNew_seq.nextval into :new.id from dual;
end;
/
ALTER TABLE ofpushdevice ADD userType NVARCHAR(100);
/
create table ofuserMsgSetting(
	id int NOT NULL,
	userid   varchar(126) NOT NULL,
	targetid varchar(128),
	propValue varchar(12)
);
/
create sequence ofuserMsgSetting_seq 
start with 1 
increment by 1 
nomaxvalue 
nocycle ;
/
create or replace trigger ofuserMsgSetting_seq_tri
before insert on ofuserMsgSetting
for each row
begin
select ofuserMsgSetting_seq.nextval into :new.id from dual;
end;
/
create index idx_oums_ud on ofuserMsgSetting(userid);
/
INSERT INTO ofVersion (name, version) VALUES ('MultiRouterPlugin', 46);
/
commit ;
/