create index em_shmr_group  on Social_historyMsgRight(userId,msgId);
/
CREATE TABLE OFROUTEMESSAGE (
  messageID	   INTEGER IDENTITY(1,1) NOT NULL,
  jid          NVARCHAR(128)      NOT NULL,
  creationDate bigint,
  message      NTEXT    NOT NULL,
  fromJid      NVARCHAR(128)
);
/
CREATE INDEX index_OFROUTEMESSAGEjid ON OFROUTEMESSAGE (jid);
/
CREATE INDEX index_OFROUTEMESSAGEmsgID ON OFROUTEMESSAGE (messageID);
/
CREATE INDEX index_OFROUTEMESSAGEcreationDate ON OFROUTEMESSAGE (creationDate);
/
CREATE TABLE OFHASROUTEDMESSAGE (
  messageID	   NVARCHAR(128)  NOT NULL ,
  jid          NVARCHAR(128)      NOT NULL,
  message      NTEXT    NOT NULL,
  creationDate bigint,
);
/
CREATE INDEX index_OFHASROUTEDMESSAGEmessageID ON OFHASROUTEDMESSAGE (messageID);
/
CREATE INDEX index_OFHASROUTEDMESSAGEjid ON OFHASROUTEDMESSAGE (jid);
/
CREATE INDEX index_OFHASRMcreationDate ON OFHASROUTEDMESSAGE(creationDate);
/
CREATE TABLE OFPUSHDEVICE(
 pushid        INTEGER IDENTITY(1,1) NOT NULL,
 userid        NVARCHAR(32)         NOT NULL,
 devicetype    NVARCHAR(64)         NOT NULL,
 token		   NVARCHAR(500)         NOT NULL,
 pushStatus    NVARCHAR(128),
 language      NVARCHAR(12),
 pushKitDeviceToken NVARCHAR(128),
 mobileVersion NVARCHAR(2),
 packagename NVARCHAR(100),
 PRIMARY KEY (pushid)
);
/
CREATE TABLE OFPUSHSETTING(
  targetId   NVARCHAR(100)         NOT NULL,
  targetType   NVARCHAR(100)         NOT NULL,
  username    NVARCHAR(100)         NOT NULL,
  propvalue	 NTEXT       NOT NULL
);
/
create table HistoryMsgRecently(
	id int primary key identity(1,1),
	fromUserId varchar(100),
	targetId varchar(100),
	targetType varchar(100),
	GroupId varchar(100),
	classname varchar(100),
	msgContent ntext,
	extra text,
	type varchar(100),
	imageUri varchar(100),
	dateTime varchar(100),
	msgid  varchar(100),
	fullAmount ntext
);
/
CREATE INDEX index_HistoryMsgRecentlyfromUserId ON HistoryMsgRecently (fromUserId);
/
CREATE INDEX index_HistoryMsgRecentlytargetId ON HistoryMsgRecently (targetId);
/
CREATE INDEX index_HistoryMsgRecentlyGroupId ON HistoryMsgRecently (GroupId);
/
CREATE INDEX index_HistoryMsgRecentlydateTime ON HistoryMsgRecently (dateTime);
/
CREATE INDEX index_HistoryMsgRecentlymsgid ON HistoryMsgRecently (msgid);
/
insert into ofProperty(name,propValue) values ('xmpp.client.processing.threads','1000');
/
insert into ofProperty(name,propValue) values ('httpbind.client.processing.threads','1000');
/
insert into ofProperty(name,propValue) values ('xmpp.client.roster.active','false');
/
insert into ofProperty(name,propValue) values ('xmpp.pep.enabled','false');
/
ALTER TABLE social_IMConversation ADD msgid NVARCHAR(128);
/
CREATE TABLE OFFUNSETTING(
 userid        NVARCHAR(100)         NOT NULL,
 funname    NVARCHAR(64)         NOT NULL,
 funvalue		   NVARCHAR(200)         NOT NULL
);
/
CREATE INDEX index_funsetUserId ON OFFUNSETTING (userid);
/
CREATE INDEX index_funsetUsername ON OFFUNSETTING (funname);
/
CREATE TABLE OFTEMPORARYRELATIONSHIP(
 username          VARCHAR(64)      NOT NULL,
 followUsername    VARCHAR(64)    NOT NULL Primary Key (username, followUsername)
);
/
ALTER TABLE social_IMRecentConver ADD isdel TINYINT;
/
ALTER TABLE social_IMRecentConver ADD istop TINYINT;
/
ALTER TABLE Social_historyMsgRight ADD isdel TINYINT;
/
insert into Social_historyMsgRight(userid,msgId)  
SELECT targetid userid ,msgid from  historymsg where targettype != 2
UNION 
SELECT fromuserid userid ,msgid from historymsg where targettype != 2
except    
select userid,msgid from Social_historyMsgRight ;
/
ALTER TABLE social_IMRecentConver ADD unreadcount int;
/
ALTER TABLE ofpushsetting ALTER COLUMN propvalue NVARCHAR(2) ;
/
ALTER TABLE social_IMRecentConver ADD updatetime bigint;
/
CREATE INDEX index_im_RecentConver_Targetid ON social_IMRecentConver (targetid);
/
CREATE INDEX index_im_RecentConver_Userid ON social_IMRecentConver (userid);
/
ALTER TABLE mobile_ding ADD  ding_module   TINYINT ;
/
ALTER TABLE mobile_ding ADD  had_send   TINYINT ;
/
ALTER TABLE HistoryMsg ADD updatetime NVARCHAR(100);
/
create table ofpushinfo(
	id INTEGER IDENTITY(1,1) NOT NULL,
	devicetype    NVARCHAR(64) NOT NULL,
	packagename   NVARCHAR(100) NOT NULL,
	appKey NVARCHAR(128),
    secret NVARCHAR(128),
    appName NVARCHAR(128),
    appId NVARCHAR(64)
);
/
create table ofunitemsginfo(
	id INTEGER IDENTITY(1,1) NOT NULL,
	uniteMsgId varchar(128),
	msgIds NTEXT
);
/
ALTER TABLE historyMsg ADD isdel TINYINT;
/
ALTER TABLE social_IMConversation ADD sendid NVARCHAR(128);
/
create table ofMsgCollect(
	id INTEGER IDENTITY(1,1) NOT NULL,
	username varchar(128),
	msgId varchar(128),
	msgContent ntext,
	className varchar(100),
	createTime varchar(100),
	collectSource varchar(512)
);
/
CREATE INDEX index_ofMsgCollectusername ON ofMsgCollect(username);
/
CREATE INDEX index_ofMsgCollectclassName ON ofMsgCollect(className);
/
CREATE INDEX index_ofMsgCollectmsgId ON ofMsgCollect(msgId);
/
ALTER TABLE social_IMRecentConver ADD sendId NVARCHAR(128);
/
ALTER TABLE social_IMRecentConver ADD targettype varchar(20);
/
ALTER TABLE social_IMRecentConver ADD msgId NVARCHAR(128);
/
ALTER TABLE social_IMRecentConver ADD msgcontent nvarchar(4000);
/
ALTER TABLE social_IMRecentConver ADD targetname varchar(100);
/
ALTER TABLE social_IMRecentConver ADD lasttime varchar(100);
/
create index index_mobile_dingreciver_dingid on mobile_dingReciver(dingid);
/
create index index_mobile_dingreciver_userid on mobile_dingReciver(userid);
/
create index index_mobile_ding_id on mobile_ding(id);
/
create table ofDeleteHistoryMsg(
	id INTEGER IDENTITY(1,1) NOT NULL,
	operator VARCHAR(128),
	operatorTime VARCHAR(36),
	msgid VARCHAR(128),
	msgcontent NTEXT,
	fromUserId VARCHAR(50),
	targetType VARCHAR(20),
	operatorIP VARCHAR(36),
	opeartorDevice VARCHAR(30)
);
/
ALTER TABLE mobile_ding ADD isdel TINYINT not null default 0;
/
ALTER TABLE mobile_ding ADD delete_date char(50);
/
ALTER TABLE mobile_dingreply ADD isdel TINYINT not null default 0;
/
ALTER TABLE mobile_dingreciver ADD isdel TINYINT not null default 0;
/
ALTER TABLE ofgroupuser ADD lasttime varchar(100);
/
ALTER TABLE social_historymsgright ADD datetime varchar(100);
/
ALTER TABLE social_IMRecentConver ADD content varchar(4000);
/
ALTER TABLE social_IMRecentConver ADD objectname varchar(128);
/
ALTER TABLE social_IMRecentConver ADD sharetypename varchar(4000);
/
ALTER TABLE social_IMRecentConver ADD sharetype varchar(128);
/
ALTER TABLE social_IMRecentConver ADD isAt varchar(4);
/
ALTER TABLE ofuser ADD isTurnover varchar(4);
/
ALTER TABLE ofgroupuser ADD isdel varchar(4);
/
CREATE TABLE OFMSGSTATISTICDAY (
  id	   INTEGER IDENTITY(1,1) NOT NULL,
  userId          NVARCHAR(128)      NOT NULL,
  day NVARCHAR(32),
  month      NVARCHAR(32),
  year      NVARCHAR(32),
  sendCount int,
  receiveCount int
);
/
create index msgstaday_userId on OFMSGSTATISTICDAY(userId);
/
create index msgstaday_day on OFMSGSTATISTICDAY(day);
/
create index msgstaday_month on OFMSGSTATISTICDAY(month);
/
create index msgstaday_year on OFMSGSTATISTICDAY(year);
/
CREATE TABLE OFMSGSTATISTICMONTH (
  id	   INTEGER IDENTITY(1,1) NOT NULL,
  userId          NVARCHAR(128)      NOT NULL,
  month      NVARCHAR(32),
  year      NVARCHAR(32),
  sendCount int,
  receiveCount int
);
/
create index msgstamonth_userId on OFMSGSTATISTICMONTH(userId);
/
create index msgstamonth_month on OFMSGSTATISTICMONTH(month);
/
create index msgstamonth_year on OFMSGSTATISTICMONTH(year);
/
CREATE TABLE OFMSGSTATISTICYEAR (
  id	   INTEGER IDENTITY(1,1) NOT NULL,
  userId          NVARCHAR(128)      NOT NULL,
  year      NVARCHAR(32),
  sendCount int,
  receiveCount int
);
/
create index msgstayear_userId on OFMSGSTATISTICYEAR(userId);
/
create index msgstayear_year on OFMSGSTATISTICYEAR(year);
/
update social_IMRecentConver set targetType = '1' where id in(select a.id  from social_IMRecentConver a ,social_IMConversation b where a.targetid = b.targetId and (a.targettype is null or a.targettype = '') and b.targettype = '1');
/
CREATE TABLE OFMSGSTATISTICCHATDAY (
  id	   INTEGER IDENTITY(1,1) NOT NULL,
  userId NVARCHAR(128) NOT NULL,
  targetId NVARCHAR(256) ,
  targetType NVARCHAR(4) ,
  day NVARCHAR(32),
  month      NVARCHAR(32),
  year      NVARCHAR(32)
);
/
create index msgstachatday_userId on OFMSGSTATISTICCHATDAY(userId);
/
create index msgstachatday_targetType on OFMSGSTATISTICCHATDAY(targetType);
/
create index msgstadaychat_day on OFMSGSTATISTICCHATDAY(day);
/
create index msgstachatday_month on OFMSGSTATISTICCHATDAY(month);
/
create index msgstachatday_year on OFMSGSTATISTICCHATDAY(year);
/
CREATE TABLE OFMSGSTATISTICCHATMONTH (
  id	   INTEGER IDENTITY(1,1) NOT NULL,
  userId          NVARCHAR(128)      NOT NULL,
  month      NVARCHAR(32),
  year      NVARCHAR(32),
  chatCount int,
  groupChatCount int
);
/
create index msgstamonthchat_userId on OFMSGSTATISTICCHATMONTH(userId);
/
create index msgstamonthchat_month on OFMSGSTATISTICCHATMONTH(month);
/
create index msgstamonthchat_year on OFMSGSTATISTICCHATMONTH(year);
/
CREATE TABLE OFMSGSTATISTICCHATYEAR (
  id	   INTEGER IDENTITY(1,1) NOT NULL,
  userId          NVARCHAR(128)      NOT NULL,
  year      NVARCHAR(32),
  chatCount int,
  groupChatCount int
  );
/
create index msgstayearchat_userId on OFMSGSTATISTICCHATYEAR(userId);
/
create index msgstayearchat_year on OFMSGSTATISTICCHATYEAR(year);
/
CREATE TABLE ofmsgpushsetting (
  id	   INTEGER IDENTITY(1,1) NOT NULL,
  userId NVARCHAR(128) NOT NULL,
  pushStatus NVARCHAR(4) ,
  startTime NVARCHAR(32),
  endTime      NVARCHAR(32)
);
/
create index ofmsgpushsetting_userId on ofmsgpushsetting(userId);
/
CREATE TABLE OFCONVERSTATISDAY (
  id	   INTEGER IDENTITY(1,1) NOT NULL,
  userId NVARCHAR(128) NOT NULL,
  targetId NVARCHAR(256) ,
  targetType NVARCHAR(4) ,
  day NVARCHAR(32),
  month      NVARCHAR(32),
  year      NVARCHAR(32),
  sendCount int,
  receiveCount int
);
/
create index converstatis_userId on OFCONVERSTATISDAY(userId);
/
create index converstatis_targetType on OFCONVERSTATISDAY(targetType);
/
create index converstatis_day on OFCONVERSTATISDAY(day);
/
create index converstatis_month on OFCONVERSTATISDAY(month);
/
create index converstatis_year on OFCONVERSTATISDAY(year);
/
CREATE TABLE OFCONVERSTATISMONTH (
  id	   INTEGER IDENTITY(1,1) NOT NULL,
  userId NVARCHAR(128) NOT NULL,
  targetId NVARCHAR(256) ,
  targetType NVARCHAR(4) ,
  month      NVARCHAR(32),
  year      NVARCHAR(32),
  sendCount int,
  receiveCount int
);
/
create index converstatism_userId on OFCONVERSTATISMONTH(userId);
/
create index converstatism_targetType on OFCONVERSTATISMONTH(targetType);
/
create index converstatism_month on OFCONVERSTATISMONTH(month);
/
create index converstatism_year on OFCONVERSTATISMONTH(year);
/
CREATE TABLE OFCONVERSTATISYEAR (
   id	   INTEGER IDENTITY(1,1) NOT NULL,
  userId NVARCHAR(128) NOT NULL,
  targetId NVARCHAR(256) ,
  targetType NVARCHAR(4) ,
  year      NVARCHAR(32),
  sendCount int,
  receiveCount int
 );
/
create index converstatisy_userId on OFCONVERSTATISYEAR(userId);
/
create index conversatisy_targetType on OFCONVERSTATISYEAR(targetType);
/
create index converstatisy_year on OFCONVERSTATISYEAR(year);
/
CREATE TABLE Social_historyMsgRecentlyRight (
	id int NOT NULL IDENTITY(1,1) PRIMARY KEY ,
	userId varchar(100) NULL ,
	msgId varchar(100) NULL ,
	isdel TINYINT,
	datetime varchar(100),
	groupId  varchar(100)
);
/
CREATE INDEX hmrr_userid_index ON Social_historyMsgRecentlyRight(userId);
/
CREATE INDEX hmrr_msgid_index ON Social_historyMsgRecentlyRight(msgId); 
/
CREATE INDEX hmrr_datetime_idx ON Social_historyMsgRecentlyRight(datetime);
/
CREATE INDEX hmrr_groupId_idx ON Social_historyMsgRecentlyRight(groupId);
/
CREATE INDEX em_shhmr_group  ON Social_historyMsgRecentlyRight(userId,msgId);
/
CREATE table ofshareMessageNew(
	id INTEGER IDENTITY(1,1) NOT NULL PRIMARY KEY,
	userId VARCHAR(128),
	shareUserId VARCHAR(128),
	msgId  VARCHAR(128),
	groupId VARCHAR(128),
	shareType VARCHAR(128),
	shareId VARCHAR(128),
	shareTime VARCHAR(24),
	targetId  VARCHAR(128),
	targetType VARCHAR(2),
	shareTimes VARCHAR(10)
);
/
create index osm_shareType on ofshareMessageNew(targetId);
/
create index osm_shareId on ofshareMessageNew(shareId);
/
CREATE table historyMsgRecentlytemp(
	groupId VARCHAR(128),
	maxDatetime VARCHAR(128),
	minDatetime  VARCHAR(128)
);
/
create index hmrt_groupId on historyMsgRecentlytemp(groupId);
/
create index hmrt_maxDatetime on historyMsgRecentlytemp(maxDatetime);
/
create table HistoryMsgSubtableData(
	id int NOT NULL IDENTITY(1,1) primary key ,
	tableName varchar(200) not null,
	startDataTime varchar(128),
	endDataTime varchar(128),
	currentInsert int,
	maxId bigint
);
/
create table msg_indexupdatelog(
	id int NOT NULL IDENTITY(1,1) primary key,
	indextype VARCHAR(4),
	data VARCHAR(128),
	tableName VARCHAR(128),
	dateTime VARCHAR(128)
);
/
create table ofpushlog(
	id int NOT NULL IDENTITY(1,1) primary key ,
	username              NVARCHAR(64)    NOT NULL,
  	entryStamp            BIGINT          NOT NULL,
  	summary               NVARCHAR(255)   NOT NULL,
  	node                  NVARCHAR(255)   NOT NULL,
  	details               NTEXT
);
/
create index idx_mcl_nm on ofMsgCollect(username);
/
create index idx_mcl_cm on ofMsgCollect(className);
/
create index idx_mcl_ct on ofMsgCollect(createTime); 
/
create table ofpushinfoNEW(
	id INTEGER IDENTITY(1,1) NOT NULL,
	packagename   NVARCHAR(100) NOT NULL,
	appName NVARCHAR(128)
);
/
ALTER TABLE ofpushdevice ADD userType NVARCHAR(100);
/
create table ofuserMsgSetting(
	id INTEGER IDENTITY(1,1) NOT NULL,
	userid   varchar(100) NOT NULL,
	targetid varchar(128),
	propValue varchar(12)
);
/
create index idx_oums_ud on ofuserMsgSetting(userid);
/
INSERT INTO ofVersion (name, version) VALUES ('MultiRouterPlugin', 46);
/