CREATE TABLE OFCONVERSTATISDAY (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  targetId VARCHAR(256),
  targetType VARCHAR(4),
  day VARCHAR(32),
  month      VARCHAR(32),
  year      VARCHAR(32),
  sendCount int,
  receiveCount int
);
/
create sequence OFCONVERSTATISDAY_seq 
start with 1 
increment by 1 
MAXVALUE 9223372036854775807 
nocycle ;
/
create or replace trigger OFCONVERSTATISDAY_seq_tri
before insert on OFCONVERSTATISDAY
for each row
begin
select OFCONVERSTATISDAY_seq.nextval into :new.id from dual;
end;;
/
create index converstatis_userId on OFCONVERSTATISDAY(userId);
/
create index converstatis_targetType on OFCONVERSTATISDAY(targetType);
/
create index converstatis_day on OFCONVERSTATISDAY(day);
/
create index converstatis_month on OFCONVERSTATISDAY(month);
/
create index converstatis_year on OFCONVERSTATISDAY(year);
/
CREATE TABLE OFCONVERSTATISMONTH (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  targetId VARCHAR(256),
  targetType VARCHAR(4),
  month      VARCHAR(32),
  year      VARCHAR(32),
  sendCount int,
  receiveCount int
);
/
create sequence OFCONVERSTATISMONTH_seq 
start with 1 
increment by 1 
MAXVALUE 9223372036854775807 
nocycle ;
/
create or replace trigger OFCONVERSTATISMONTH_seq_tri
before insert on OFCONVERSTATISMONTH
for each row
begin
select OFCONVERSTATISMONTH_seq.nextval into :new.id from dual;
end;;
/
create index converstatism_userId on OFCONVERSTATISMONTH(userId);
/
create index converstatism_targetType on OFCONVERSTATISMONTH(targetType);
/
create index converstatism_month on OFCONVERSTATISMONTH(month);
/
create index converstatism_year on OFCONVERSTATISMONTH(year);
/
CREATE TABLE OFCONVERSTATISYEAR (
  id	   int  NOT NULL primary key,
  userId          VARCHAR(128)      NOT NULL,
  targetId VARCHAR(256),
  targetType VARCHAR(4),
  year      VARCHAR(32),
  sendCount int,
  receiveCount int
);
/
create sequence OFCONVERSTATISYEAR_seq 
start with 1 
increment by 1 
MAXVALUE 9223372036854775807 
nocycle ;
/
create or replace trigger OFCONVERSTATISYEAR_seq_tri
before insert on OFCONVERSTATISYEAR
for each row
begin
select OFCONVERSTATISYEAR_seq.nextval into :new.id from dual;
end;;
/
create index converstatisy_userId on OFCONVERSTATISYEAR(userId);
/
create index conversatisy_targetType on OFCONVERSTATISYEAR(targetType);
/
create index converstatisy_year on OFCONVERSTATISYEAR(year);
/
UPDATE ofVersion SET version = 35 WHERE name = 'MultiRouterPlugin';
/