-- 《批量查询人员在线状态》


-- 调用示例：
-- local jids, udidAtDomain, currentNode = "12334,12515,12334", "cspvjkuu@weaver", "192.168.1.182";

-- 初始化================================================================================================================
-- 传入 jid,多个以逗号分隔 、当前节点。两个个均为字符串
local jids, udidAtDomain, currentNode = KEYS[1], KEYS[2], KEYS[3];

-- 待推送数组，待保存数组，待发送数组，结果集数组，所有节点数组
local toPush, toSave, toSend, result, cluster_nodes = {}, {}, {}, {}, {};

-- 查询所有节点
cluster_nodes = redis.call('zrange', 'cluster_nodes', 0, -1);

-- 遍历所有 jid
for m, jid in ipairs(string.split(jids, ',')) do
    local jidWithUdidAtDomain = jid .. '|' .. udidAtDomain;
    -- pc是否在线，mobile是否在线，pc是否本地在线，mobile是否本地在线
    local pcOnlineFlag, mobileOnlieFlag, pcOnlineLocal, mobileOnlineLocal = false, false, false, false;
    -- pc在线节点，mobile在线节点
    local pcOnlineNode, mobileOnlineNode = '@#$', '%^&';

    -- 遍历节点，初始化当前jid的各种状态======================================================================================
    for n, node in ipairs(cluster_nodes) do
        local pcOnline = redis.call('zscore', node, jidWithUdidAtDomain .. '/pc');
        local mobileOnline = redis.call('zscore', node, jidWithUdidAtDomain .. '/mobile');

        if not pcOnline then
            redis.log(redis.LOG_NOTICE, jidWithUdidAtDomain .. '/pc' .. ' 不在节点 ' .. node .. '上');
            -- 如果在线
        else redis.log(redis.LOG_NOTICE, jidWithUdidAtDomain .. '/pc' .. ' 在节点 ' .. node .. '上');
            pcOnlineFlag = true;
            pcOnlineNode = node;
            -- 进一步判断是否是本地在线，如果传入的参数节点，等于当前正在遍历的节点，即 KEYS[3] = node，则pc本地在线
            if currentNode == node then
                pcOnlineLocal = true;
            end
        end

        if not mobileOnline then
            redis.log(redis.LOG_NOTICE, jidWithUdidAtDomain .. '/mobile' .. ' 不在节点 ' .. node .. '上');
            -- 如果在线
        else redis.log(redis.LOG_NOTICE, jidWithUdidAtDomain .. '/mobile' .. ' 在节点 ' .. node .. '上');
            mobileOnlieFlag = true;
            mobileOnlineNode = node;
            -- 进一步判断是否是本地在线，如果传入的参数节点，等于当前正在遍历的节点，即 KEYS[3] = node，则mobile本地在线
            if currentNode == node then
                mobileOnlieFlag = true;
            end
        end
    end

    -- 不在线（pc和mobile都不在线）：存入待推送List===========================================================================
    if (not pcOnlineFlag) and (not mobileOnlieFlag) then
        table.insert(toPush, jid);
        -- 在线==============================================================================================================
    else
        -- mobile 在线 （本节点）, pc端不在线 ：存入待发送List
        if mobileOnlineLocal and (not pcOnlineFlag) then
            table.insert(toSend, jid);
        end
        -- mobile 在线 （其他节点）, pc端不在线 ： 存入待保存List
        if mobileOnlieFlag and (not mobileOnlineLocal) and (not pcOnlineFlag) then
            table.insert(toSave, jid);
        end

        -- mobile 不在线 ,pc端在线 （本节点）：存入待发送List，
        local pdSt = redis.call('get', 'push_device_' .. jidWithUdidAtDomain);
        local _, flagSt = '', '';
        --手机端是否需要推送。需要推送，存入待推送List；不需要推送，不处理 。
        if pdSt then
            _, flagSt = string.find(pdSt, '\"pushStatus\":\"\"');
        else
            flagSt = false;
        end
        if (not mobileOnlieFlag) and pcOnlineLocal then
            table.insert(toSend, jid);
            if pdSt and not flagSt then
                table.insert(toPush, jid);
            end
        end

        -- mobile 不在线 ,pc端在线 （其他节点） ： 存入待保存List
        local pdSec = redis.call('get', 'push_device_' .. jidWithUdidAtDomain);
        local _, flagSec = '', ''
        --手机端是否需要推送。需要推送，存入待推送List；不需要推送，不处理 。
        if pdSec then
            _, flagSec = string.find(pdSec, '\"pushStatus\":\"\"');
        else
            flagSec = false;
        end
        if (not mobileOnlieFlag) and pcOnlineFlag and (not pcOnlineLocal) then
            table.insert(toSave, jid);
            if pdSec and not flagSec then
                table.insert(toPush, jid);
            end
        end

        -- mobile 和 pc端同时在线 。=======================================================================================
        if mobileOnlieFlag and pcOnlineFlag then
            -- mobile 在本节点，pc在本节点 ：存入待发送List
            if mobileOnlineLocal and pcOnlineLocal then
                table.insert(toSend, jid);
            end
            -- mobile 在本节点，pc在其他节点 ：存入待发送List
            if mobileOnlineLocal and (not pcOnlineLocal) then
                table.insert(toSend, jid);
            end
            -- mobile 在其他节点，pc在本节点 ：存入待发送List ，存入待保存List
            if (not mobileOnlineLocal) and pcOnlineLocal then
                table.insert(toSave, jid);
            end
            -- pc, mobile 同时在线，但是都不在本节点上
            if (not mobileOnlineLocal) and (not pcOnlineLocal) then
                -- mobile在其他节点，pc在其他节点，且mobile和pc都在同一个节点 ： 存入待保存List
                if pcOnlineNode == mobileOnlineNode then
                    table.insert(toSave, jid);
                    -- mobile在其他节点，pc在其他节点 ，且mobile和pc不在同一个节点： 存入待保存List
                else
                    table.insert(toSave, jid);
                end
            end
        end
    end
end

-- 把三个数组放到一个更大的数组，然后返回结果数组
table.insert(result, toPush);
table.insert(result, toSave);
table.insert(result, toSend);
return result;